/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.TileEntitySCTE;
import net.geforcemods.securitycraft.blocks.BlockInventoryScanner;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInventoryScannerField
extends BlockContainer
implements IIntersectable {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool HORIZONTAL = PropertyBool.func_177716_a((String)"horizontal");
    public static final AxisAlignedBB EAST_WEST_SHAPE = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    public static final AxisAlignedBB NORTH_SOUTH_SHAPE = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    public static final AxisAlignedBB HORIZONTAL_SHAPE = new AxisAlignedBB(0.0, 0.375, 0.0, 1.0, 0.625, 1.0);

    public BlockInventoryScannerField(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)HORIZONTAL, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return null;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(world, pos);
        if (connectedScanner != null && connectedScanner.doesFieldSolidify()) {
            if (entity instanceof EntityPlayer && !EntityUtils.isInvisible((EntityLivingBase)((EntityPlayer)entity))) {
                if (ModuleUtils.isAllowed((IModuleInventory)connectedScanner, entity)) {
                    BlockInventoryScannerField.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185506_k);
                }
                for (int i = 0; i < 10; ++i) {
                    if (connectedScanner.getStackInSlotCopy(i).func_190926_b() || !BlockInventoryScannerField.checkInventory((EntityPlayer)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i), false)) continue;
                    BlockInventoryScannerField.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)world, pos));
                }
            } else if (entity instanceof EntityItem) {
                for (int i = 0; i < 10; ++i) {
                    if (connectedScanner.getStackInSlotCopy(i).func_190926_b() || ((EntityItem)entity).func_92059_d().func_190926_b() || !BlockInventoryScannerField.checkEntityItem((EntityItem)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i), false)) continue;
                    BlockInventoryScannerField.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)world, pos));
                }
            }
        }
        BlockInventoryScannerField.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185506_k);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, IBlockState state, Entity entity) {
        block5: {
            TileEntityInventoryScanner connectedScanner;
            block4: {
                connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(world, pos);
                if (connectedScanner == null || connectedScanner.doesFieldSolidify()) {
                    return;
                }
                if (!(entity instanceof EntityPlayer) || EntityUtils.isInvisible((EntityLivingBase)entity)) break block4;
                if (ModuleUtils.isAllowed((IModuleInventory)connectedScanner, entity)) {
                    return;
                }
                for (int i = 0; i < 10; ++i) {
                    if (connectedScanner.getStackInSlotCopy(i).func_190926_b()) continue;
                    BlockInventoryScannerField.checkInventory((EntityPlayer)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i), true);
                }
                break block5;
            }
            if (!(entity instanceof EntityItem)) break block5;
            for (int i = 0; i < 10; ++i) {
                if (connectedScanner.getStackInSlotCopy(i).func_190926_b() || ((EntityItem)entity).func_92059_d().func_190926_b()) continue;
                BlockInventoryScannerField.checkEntityItem((EntityItem)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i), true);
            }
        }
    }

    public static boolean checkInventory(EntityPlayer player, TileEntityInventoryScanner te, ItemStack stack, boolean allowInteraction) {
        boolean hasRedstoneModule;
        boolean hasSmartModule = te.hasModule(EnumModuleType.SMART);
        boolean hasStorageModule = allowInteraction && te.hasModule(EnumModuleType.STORAGE);
        boolean bl = hasRedstoneModule = allowInteraction && te.hasModule(EnumModuleType.REDSTONE);
        if (!hasRedstoneModule && !hasStorageModule && allowInteraction || te.getOwner().isOwner(player)) {
            return false;
        }
        return BlockInventoryScannerField.loopInventory((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, stack, te, hasSmartModule, hasStorageModule, hasRedstoneModule) || BlockInventoryScannerField.loopInventory((NonNullList<ItemStack>)player.field_71071_by.field_70460_b, stack, te, hasSmartModule, hasStorageModule, hasRedstoneModule) || BlockInventoryScannerField.loopInventory((NonNullList<ItemStack>)player.field_71071_by.field_184439_c, stack, te, hasSmartModule, hasStorageModule, hasRedstoneModule);
    }

    private static boolean loopInventory(NonNullList<ItemStack> inventory, ItemStack stack, TileEntityInventoryScanner te, boolean hasSmartModule, boolean hasStorageModule, boolean hasRedstoneModule) {
        for (int i = 1; i <= inventory.size(); ++i) {
            ItemStack itemStackChecking = (ItemStack)inventory.get(i - 1);
            if (itemStackChecking.func_190926_b()) continue;
            if (BlockInventoryScannerField.areItemsEqual(itemStackChecking, stack, hasSmartModule)) {
                if (hasStorageModule) {
                    te.addItemToStorage((ItemStack)inventory.get(i - 1));
                    inventory.set(i - 1, (Object)ItemStack.field_190927_a);
                }
                if (hasRedstoneModule) {
                    BlockInventoryScannerField.updateInventoryScannerPower(te);
                }
                return true;
            }
            if (!BlockInventoryScannerField.checkForShulkerBox(itemStackChecking, stack, te, hasSmartModule, hasStorageModule, hasRedstoneModule)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkEntityItem(EntityItem entity, TileEntityInventoryScanner te, ItemStack stack, boolean allowInteraction) {
        boolean hasRedstoneModule;
        boolean hasSmartModule = te.hasModule(EnumModuleType.SMART);
        boolean hasStorageModule = allowInteraction && te.hasModule(EnumModuleType.STORAGE);
        boolean bl = hasRedstoneModule = allowInteraction && te.hasModule(EnumModuleType.REDSTONE);
        if (!hasRedstoneModule && !hasStorageModule && allowInteraction) {
            return false;
        }
        if (BlockInventoryScannerField.areItemsEqual(entity.func_92059_d(), stack, hasSmartModule)) {
            if (hasStorageModule) {
                te.addItemToStorage(entity.func_92059_d());
                entity.func_70106_y();
            }
            if (hasRedstoneModule) {
                BlockInventoryScannerField.updateInventoryScannerPower(te);
            }
            return true;
        }
        return BlockInventoryScannerField.checkForShulkerBox(entity.func_92059_d(), stack, te, hasSmartModule, hasStorageModule, hasRedstoneModule);
    }

    private static boolean checkForShulkerBox(ItemStack item, ItemStack stackToCheck, TileEntityInventoryScanner te, boolean hasSmartModule, boolean hasStorageModule, boolean hasRedstoneModule) {
        if (item != null && !item.func_190926_b() && item.func_77978_p() != null && Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockShulkerBox) {
            NBTTagList list = item.func_77978_p().func_74775_l("BlockEntityTag").func_150295_c("Items", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ItemStack itemInChest = new ItemStack(list.func_150305_b(i));
                if (!BlockInventoryScannerField.areItemsEqual(itemInChest, stackToCheck, hasSmartModule)) continue;
                if (hasStorageModule) {
                    te.addItemToStorage(itemInChest);
                    list.func_74744_a(i);
                }
                if (hasRedstoneModule) {
                    BlockInventoryScannerField.updateInventoryScannerPower(te);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean areItemsEqual(ItemStack firstItemStack, ItemStack secondItemStack, boolean hasSmartModule) {
        return hasSmartModule && BlockInventoryScannerField.areItemStacksEqual(firstItemStack, secondItemStack) && ItemStack.func_77970_a((ItemStack)firstItemStack, (ItemStack)secondItemStack) || !hasSmartModule && BlockInventoryScannerField.areItemStacksEqual(firstItemStack, secondItemStack);
    }

    private static void updateInventoryScannerPower(TileEntityInventoryScanner te) {
        if (!te.shouldProvidePower()) {
            te.setShouldProvidePower(true);
        }
        te.setCooldown(60);
        BlockInventoryScannerField.checkAndUpdateTEAppropriately(te);
        BlockUtils.updateAndNotify(te.func_145831_w(), te.func_174877_v(), te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c(), 1, true);
    }

    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        ItemStack s1 = stack1.func_77946_l();
        ItemStack s2 = stack2.func_77946_l();
        s1.func_190920_e(1);
        s2.func_190920_e(1);
        return ItemStack.func_77989_b((ItemStack)s1, (ItemStack)s2);
    }

    private static void checkAndUpdateTEAppropriately(TileEntityInventoryScanner te) {
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(te.func_145831_w(), te.func_174877_v());
        if (connectedScanner == null) {
            return;
        }
        te.setShouldProvidePower(true);
        te.setCooldown(60);
        BlockUtils.updateAndNotify(te.func_145831_w(), te.func_174877_v(), te.func_145838_q(), 1, true);
        connectedScanner.setShouldProvidePower(true);
        connectedScanner.setCooldown(60);
        BlockUtils.updateAndNotify(connectedScanner.func_145831_w(), connectedScanner.func_174877_v(), connectedScanner.func_145838_q(), 1, true);
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
                this.checkAndDestroyFields(world, pos, (p, i) -> p.func_177985_f(i.intValue()));
                this.checkAndDestroyFields(world, pos, (p, i) -> p.func_177965_g(i.intValue()));
            } else if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                this.checkAndDestroyFields(world, pos, (p, i) -> p.func_177964_d(i.intValue()));
                this.checkAndDestroyFields(world, pos, (p, i) -> p.func_177970_e(i.intValue()));
            }
        }
    }

    private void checkAndDestroyFields(World world, BlockPos pos, BiFunction<BlockPos, Integer, BlockPos> posModifier) {
        for (int i = 0; i < ConfigHandler.inventoryScannerRange; ++i) {
            BlockPos modifiedPos = posModifier.apply(pos, i);
            if (world.func_180495_p(modifiedPos) != SCContent.inventoryScanner) continue;
            for (int j = 1; j < i; ++j) {
                world.func_175655_b(posModifier.apply(pos, j), false);
            }
            break;
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)HORIZONTAL)).booleanValue()) {
            return HORIZONTAL_SHAPE;
        }
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.EAST || state.func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            return EAST_WEST_SHAPE;
        }
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH || state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            return NORTH_SOUTH_SHAPE;
        }
        return super.func_185496_a(state, world, pos);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a((IProperty)HORIZONTAL, (Comparable)Boolean.valueOf(meta > 3));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)HORIZONTAL) != false ? 4 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HORIZONTAL});
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySCTE().intersectsEntities();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        if ((side == EnumFacing.UP || side == EnumFacing.DOWN) && block == this) {
            return false;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }
}

