/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.TileEntityOwnable;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityIronFence;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockIronFence
extends BlockFence
implements IIntersectable {
    public BlockIronFence(Material material) {
        super(material, MapColor.field_151668_h);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean func_176524_e(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block != this && !(block instanceof BlockFenceGate) && block != SCContent.reinforcedFencegate) {
            if (block.func_176223_P().func_185904_a().func_76218_k()) {
                return block.func_176223_P().func_185904_a() != Material.field_151572_C;
            }
            return false;
        }
        return true;
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityItem) {
            return;
        }
        if (entity instanceof EntityPlayer) {
            if (((TileEntityOwnable)world.func_175625_s(pos)).getOwner().isOwner((EntityPlayer)entity)) {
                return;
            }
        } else if (entity instanceof EntityCreeper) {
            EntityCreeper creeper = (EntityCreeper)entity;
            EntityLightningBolt lightning = new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true);
            creeper.func_70077_a(lightning);
            creeper.func_70066_B();
            return;
        }
        entity.func_70097_a(CustomDamageSources.ELECTRICITY, 6.0f);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, world, pos, eventID, eventParam);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(eventID, eventParam);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityIronFence().intersectsEntities();
    }
}

