/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.items.ItemKeycard;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockKeycardReader
extends BlockDisguisable {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockKeycardReader(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185852_e);
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        IBlockState north = world.func_180495_p(pos.func_177978_c());
        IBlockState south = world.func_180495_p(pos.func_177968_d());
        IBlockState west = world.func_180495_p(pos.func_177976_e());
        IBlockState east = world.func_180495_p(pos.func_177974_f());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.NORTH && north.func_185913_b() && !south.func_185913_b()) {
            facing = EnumFacing.SOUTH;
        } else if (facing == EnumFacing.SOUTH && south.func_185913_b() && !north.func_185913_b()) {
            facing = EnumFacing.NORTH;
        } else if (facing == EnumFacing.WEST && west.func_185913_b() && !east.func_185913_b()) {
            facing = EnumFacing.EAST;
        } else if (facing == EnumFacing.EAST && east.func_185913_b() && !west.func_185913_b()) {
            facing = EnumFacing.WEST;
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntityKeycardReader te = (TileEntityKeycardReader)world.func_175625_s(pos);
            if (ModuleUtils.isDenied(te, (Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)new TextComponentTranslation(this.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
                }
            } else {
                boolean isCodebreaker;
                ItemStack stack = player.func_184586_b(hand);
                Item item = stack.func_77973_b();
                boolean bl = isCodebreaker = item == SCContent.codebreaker;
                if (!(item instanceof ItemKeycard && stack.func_77942_o() && stack.func_77978_p().func_74767_n("linked") || isCodebreaker)) {
                    if (te.getOwner().isOwner(player) || ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
                        player.openGui((Object)SecurityCraft.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    }
                } else if (item != SCContent.limitedUseKeycard) {
                    if (isCodebreaker) {
                        if (!player.func_184812_l_()) {
                            stack.func_77972_a(1, (EntityLivingBase)player);
                        }
                        if (new Random().nextInt(3) == 1) {
                            BlockKeycardReader.activate(world, pos, state, te.getSignalLength());
                        }
                    } else {
                        ITextComponent feedback = this.insertCard(world, pos, state, te, stack, player);
                        if (feedback != null) {
                            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)new TextComponentTranslation(this.func_149739_a() + ".name", new Object[0]), feedback, TextFormatting.RED);
                        }
                    }
                }
            }
        }
        return true;
    }

    public ITextComponent insertCard(World world, BlockPos pos, IBlockState state, TileEntityKeycardReader te, ItemStack stack, EntityPlayer player) {
        NBTTagCompound tag = stack.func_77978_p();
        if (!te.getOwner().getUUID().equals(tag.func_74779_i("ownerUUID"))) {
            return new TextComponentTranslation("messages.securitycraft:keycardReader.differentOwner", new Object[0]);
        }
        if (te.getSignature() != tag.func_74762_e("signature")) {
            return new TextComponentTranslation("messages.securitycraft:keycardReader.wrongSignature", new Object[0]);
        }
        int level = ((ItemKeycard)stack.func_77973_b()).getLevel();
        if (!te.getAcceptedLevels()[level]) {
            return new TextComponentTranslation("messages.securitycraft:keycardReader.wrongLevel", new Object[]{level + 1});
        }
        boolean powered = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)POWERED);
        if (tag.func_74767_n("limited")) {
            int uses = tag.func_74762_e("uses");
            if (uses <= 0) {
                return new TextComponentTranslation("messages.securitycraft:keycardReader.noUses", new Object[0]);
            }
            if (!player.func_184812_l_() && !powered) {
                tag.func_74768_a("uses", --uses);
            }
        }
        if (!powered) {
            BlockKeycardReader.activate(world, pos, state, te.getSignalLength());
        }
        return null;
    }

    public static void activate(World world, BlockPos pos, IBlockState state, int signalLength) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
        world.func_175685_c(pos, SCContent.keycardReader, false);
        world.func_175684_a(pos, SCContent.keycardReader, signalLength);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            world.func_175685_c(pos, SCContent.keycardReader, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.func_177956_o() + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            world.func_175688_a(EnumParticleTypes.REDSTONE, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        if (meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta].func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.values()[meta])).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta - 6]).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177228_b().containsKey((Object)POWERED) && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 6;
        }
        if (state.func_177228_b().containsKey((Object)FACING)) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityKeycardReader();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }
}

