/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import java.util.function.Function;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.blocks.BlockFrame;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypad;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockKeypad
extends BlockDisguisable {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockKeypad(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return false;
        }
        TileEntityKeypad te = (TileEntityKeypad)world.func_175625_s(pos);
        if (ModuleUtils.isDenied(te, (Entity)player)) {
            if (te.sendsMessages()) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(this.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
            }
            return true;
        }
        if (ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
            if (te.sendsMessages()) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(this.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), TextFormatting.GREEN);
            }
            BlockKeypad.activate(world, pos, state, te.getSignalLength());
            return true;
        }
        if (!PlayerUtils.isHoldingItem(player, SCContent.codebreaker, hand) && !PlayerUtils.isHoldingItem(player, SCContent.keyPanel, hand)) {
            te.openPasswordGUI(player);
        }
        return true;
    }

    public static void activate(World world, BlockPos pos, IBlockState state, int signalLength) {
        if (state.func_177230_c() != SCContent.keypad) {
            return;
        }
        world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
        world.func_175685_c(pos, SCContent.keypad, false);
        world.func_175684_a(pos, SCContent.keypad, signalLength);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        world.func_175685_c(pos, SCContent.keypad, false);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(world, pos, state);
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        IBlockState north = world.func_180495_p(pos.func_177978_c());
        IBlockState south = world.func_180495_p(pos.func_177968_d());
        IBlockState west = world.func_180495_p(pos.func_177976_e());
        IBlockState east = world.func_180495_p(pos.func_177974_f());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.NORTH && north.func_185913_b() && !south.func_185913_b()) {
            facing = EnumFacing.SOUTH;
        } else if (facing == EnumFacing.SOUTH && south.func_185913_b() && !north.func_185913_b()) {
            facing = EnumFacing.NORTH;
        } else if (facing == EnumFacing.WEST && west.func_185913_b() && !east.func_185913_b()) {
            facing = EnumFacing.EAST;
        } else if (facing == EnumFacing.EAST && east.func_185913_b() && !west.func_185913_b()) {
            facing = EnumFacing.WEST;
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 15) {
            return this.func_176223_P();
        }
        if (meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta].func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.values()[meta])).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta - 6]).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177228_b().containsKey((Object)POWERED) && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 6;
        }
        if (!state.func_177228_b().containsKey((Object)FACING)) {
            return 15;
        }
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityKeypad();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public static class Convertible
    implements Function<Object, IPasswordConvertible>,
    IPasswordConvertible {
        @Override
        public IPasswordConvertible apply(Object o) {
            return this;
        }

        @Override
        public Block getOriginalBlock() {
            return SCContent.frame;
        }

        @Override
        public boolean convert(EntityPlayer player, World world, BlockPos pos) {
            Owner oldOwner = ((IOwnable)world.func_175625_s(pos)).getOwner();
            world.func_175656_a(pos, SCContent.keypad.func_176223_P().func_177226_a((IProperty)FACING, world.func_180495_p(pos).func_177229_b((IProperty)BlockFrame.FACING)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            ((IOwnable)world.func_175625_s(pos)).setOwner(oldOwner.getUUID(), oldOwner.getName());
            return true;
        }
    }
}

