/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.blocks.BlockLaserField;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityLaserBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLaserBlock
extends BlockDisguisable {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockLaserBlock(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            this.setLaser(new Owner(entity.func_70005_c_(), entity.func_110124_au().toString()), world, pos);
        }
    }

    public void setLaser(Owner owner, World world, BlockPos pos) {
        TileEntityLaserBlock thisTe = (TileEntityLaserBlock)world.func_175625_s(pos);
        block0: for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos offsetPos;
            Block offsetBlock;
            int boundType = facing == EnumFacing.UP || facing == EnumFacing.DOWN ? 1 : (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? 2 : 3);
            for (int i = 1; i <= ConfigHandler.laserBlockRange && ((offsetBlock = world.func_180495_p(offsetPos = pos.func_177967_a(facing, i)).func_177230_c()) == Blocks.field_150350_a || offsetBlock == SCContent.laserBlock); ++i) {
                if (offsetBlock != SCContent.laserBlock) continue;
                TileEntityLaserBlock thatTe = (TileEntityLaserBlock)world.func_175625_s(offsetPos);
                if (!owner.equals(thatTe.getOwner())) continue block0;
                CustomizableSCTE.link(thisTe, thatTe);
                for (EnumModuleType type : thatTe.getInsertedModules()) {
                    thisTe.insertModule(thatTe.getModule(type));
                }
                if (!thisTe.isEnabled() || !thatTe.isEnabled()) continue block0;
                for (int j = 1; j < i; ++j) {
                    offsetPos = pos.func_177967_a(facing, j);
                    if (world.func_180495_p(offsetPos).func_177230_c() != Blocks.field_150350_a) continue;
                    world.func_175656_a(offsetPos, SCContent.laserField.func_176223_P().func_177226_a((IProperty)BlockLaserField.BOUNDTYPE, (Comparable)Integer.valueOf(boundType)));
                    TileEntity te = world.func_175625_s(offsetPos);
                    if (!(te instanceof IOwnable)) continue;
                    ((IOwnable)te).setOwner(thisTe.getOwner().getUUID(), thisTe.getOwner().getName());
                }
                continue block0;
            }
        }
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            BlockLaserBlock.destroyAdjacentLasers(world, pos);
        }
    }

    public static void destroyAdjacentLasers(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos offsetPos;
            IBlockState state;
            int boundType = facing == EnumFacing.UP || facing == EnumFacing.DOWN ? 1 : (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? 2 : 3);
            for (int i = 1; i <= ConfigHandler.laserBlockRange && (state = world.func_180495_p(offsetPos = pos.func_177967_a(facing, i))).func_177230_c() != SCContent.laserBlock; ++i) {
                if (state.func_177230_c() != SCContent.laserField || (Integer)state.func_177229_b((IProperty)BlockLaserField.BOUNDTYPE) != boundType) continue;
                world.func_175655_b(offsetPos, false);
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.setLaser(((CustomizableSCTE)world.func_175625_s(pos)).getOwner(), world, pos);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.func_177956_o() + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            world.func_175688_a(EnumParticleTypes.REDSTONE, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return state.func_177230_c() != this ? 0 : ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityLaserBlock().linkable();
    }
}

