/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.TileEntitySCTE;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLaserField
extends BlockContainer
implements IIntersectable {
    public static final PropertyInteger BOUNDTYPE = PropertyInteger.func_177719_a((String)"boundtype", (int)1, (int)3);
    private static final AxisAlignedBB BOUNDTYPE_1_AABB;
    private static final AxisAlignedBB BOUNDTYPE_2_AABB;
    private static final AxisAlignedBB BOUNDTYPE_3_AABB;

    public BlockLaserField(Material material) {
        super(material);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityLivingBase && !EntityUtils.isInvisible((EntityLivingBase)entity)) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                for (int i = 0; i < ConfigHandler.laserBlockRange; ++i) {
                    BlockPos offsetPos = pos.func_177967_a(facing, i);
                    IBlockState offsetState = world.func_180495_p(offsetPos);
                    Block block = offsetState.func_177230_c();
                    if (block != SCContent.laserBlock || ((Boolean)offsetState.func_177229_b((IProperty)BlockLaserBlock.POWERED)).booleanValue()) continue;
                    TileEntity te = world.func_175625_s(offsetPos);
                    if (te instanceof IModuleInventory && ModuleUtils.isAllowed((IModuleInventory)te, entity)) {
                        return;
                    }
                    world.func_175656_a(offsetPos, offsetState.func_177226_a((IProperty)BlockLaserBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                    world.func_175684_a(offsetPos, SCContent.laserBlock, 50);
                    if (!(te instanceof IModuleInventory) || !((IModuleInventory)te).hasModule(EnumModuleType.HARMING) || entity instanceof EntityPlayer && ((IOwnable)te).getOwner().isOwner((EntityPlayer)entity)) continue;
                    ((EntityLivingBase)entity).func_70097_a(CustomDamageSources.LASER, 10.0f);
                }
            }
        }
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            EnumFacing[] facingArray;
            block0: for (EnumFacing facing : facingArray = new EnumFacing[]{EnumFacing.func_82600_a((int)(((Integer)state.func_177229_b((IProperty)BOUNDTYPE) - 1) * 2)), EnumFacing.func_82600_a((int)(((Integer)state.func_177229_b((IProperty)BOUNDTYPE) - 1) * 2)).func_176734_d()}) {
                for (int i = 0; i < ConfigHandler.laserBlockRange; ++i) {
                    if (world.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c() != SCContent.laserBlock) continue;
                    for (int j = 1; j < i; ++j) {
                        world.func_175655_b(pos.func_177967_a(facing, j), false);
                    }
                    continue block0;
                }
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if ((Integer)source.func_180495_p(pos).func_177229_b((IProperty)BOUNDTYPE) == 1) {
            return BOUNDTYPE_1_AABB;
        }
        if ((Integer)source.func_180495_p(pos).func_177229_b((IProperty)BOUNDTYPE) == 2) {
            return BOUNDTYPE_2_AABB;
        }
        if ((Integer)source.func_180495_p(pos).func_177229_b((IProperty)BOUNDTYPE) == 3) {
            return BOUNDTYPE_3_AABB;
        }
        return field_185505_j;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BOUNDTYPE, (Comparable)Integer.valueOf(1));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BOUNDTYPE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BOUNDTYPE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BOUNDTYPE});
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySCTE().intersectsEntities();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        int boundType = (Integer)state.func_177229_b((IProperty)BOUNDTYPE);
        return rot == Rotation.CLOCKWISE_180 ? state : state.func_177226_a((IProperty)BOUNDTYPE, (Comparable)Integer.valueOf(boundType == 2 ? 3 : (boundType == 3 ? 2 : 1)));
    }

    static {
        float px = 0.0625f;
        BOUNDTYPE_1_AABB = new AxisAlignedBB(6.75 * (double)px, 0.0, 6.75 * (double)px, 9.25 * (double)px, 1.0, 9.25 * (double)px);
        BOUNDTYPE_2_AABB = new AxisAlignedBB(6.75 * (double)px, 6.75 * (double)px, 0.0, 9.25 * (double)px, 9.25 * (double)px, 1.0);
        BOUNDTYPE_3_AABB = new AxisAlignedBB(0.0, 6.75 * (double)px, 6.75 * (double)px, 1.0, 9.25 * (double)px, 9.25 * (double)px);
    }
}

