/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import com.google.common.collect.Sets;
import java.util.Collection;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityBullet
extends EntityArrow {
    private static final DataParameter<Owner> OWNER = EntityDataManager.func_187226_a(EntityBullet.class, Owner.getSerializer());
    private Collection<PotionEffect> potionEffects = Sets.newHashSet();

    public EntityBullet(World world) {
        super(world);
        this.func_70105_a(0.15f, 0.1f);
    }

    public EntityBullet(World world, EntitySentry shooter) {
        super(world, (EntityLivingBase)shooter);
        Owner owner = shooter.getOwner();
        this.potionEffects = shooter.func_70651_bq();
        this.field_70180_af.func_187227_b(OWNER, (Object)new Owner(owner.getName(), owner.getUUID()));
        this.func_70105_a(0.15f, 0.1f);
    }

    public Owner getOwner() {
        return (Owner)this.field_70180_af.func_187225_a(OWNER);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, (Object)new Owner());
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (!this.potionEffects.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (PotionEffect effect : this.potionEffects) {
                list.func_74742_a((NBTBase)effect.func_82719_a(new NBTTagCompound()));
            }
            compound.func_74782_a("PotionEffects", (NBTBase)list);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        NBTTagList potionList;
        super.func_70037_a(compound);
        if (compound.func_150297_b("PotionEffects", 9) && !(potionList = compound.func_150295_c("PotionEffects", 10)).func_82582_d()) {
            for (int i = 0; i < potionList.func_74745_c(); ++i) {
                PotionEffect effect = PotionEffect.func_82722_b((NBTTagCompound)potionList.func_150305_b(i));
                if (effect == null) continue;
                this.potionEffects.add(effect);
            }
        }
    }

    protected void func_184549_a(RayTraceResult raytraceResult) {
        Entity target = raytraceResult.field_72308_g;
        if (target != null && !(target instanceof EntitySentry)) {
            target.func_70097_a(DamageSource.func_76353_a((EntityArrow)this, (Entity)(this.field_70250_c == null ? this : this.field_70250_c)), (float)MathHelper.func_76143_f((double)((double)MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y)) * 2.0)));
            if (target instanceof EntityLivingBase && !this.potionEffects.isEmpty()) {
                for (PotionEffect effect : this.potionEffects) {
                    ((EntityLivingBase)target).func_70690_d(effect);
                }
            }
        }
        this.func_70106_y();
    }

    protected void func_184548_a(EntityLivingBase entity) {
        this.func_70106_y();
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }
}

