/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.entity.EntityBullet;
import net.geforcemods.securitycraft.entity.ai.EntityAIAttackRangedIfEnabled;
import net.geforcemods.securitycraft.entity.ai.EntityAITargetNearestPlayerOrMob;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.network.client.InitSentryAnimation;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadChest;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.PositionImpl;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class EntitySentry
extends EntityCreature
implements IRangedAttackMob {
    private static final DataParameter<Owner> OWNER = EntityDataManager.func_187226_a(EntitySentry.class, Owner.getSerializer());
    private static final DataParameter<NBTTagCompound> DISGUISE_MODULE = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<NBTTagCompound> ALLOWLIST = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Boolean> HAS_SPEED_MODULE = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MODE = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> HEAD_ROTATION = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final float MAX_TARGET_DISTANCE = 20.0f;
    private static final float ANIMATION_STEP_SIZE = 0.025f;
    private static final float UPWARDS_ANIMATION_LIMIT = 0.025f;
    private static final float DOWNWARDS_ANIMATION_LIMIT = 0.9f;
    private float headYTranslation = 0.9f;
    public boolean animateUpwards = true;
    public boolean animate = false;
    private long previousTargetId = Long.MIN_VALUE;
    private static Random notRandom = new NotRandom();

    public EntitySentry(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntitySentry(World world, EntityPlayer owner) {
        this(world, new Owner(owner.func_70005_c_(), EntityPlayer.func_146094_a((GameProfile)owner.func_146103_bH()).toString()));
    }

    public EntitySentry(World world, Owner owner) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70180_af.func_187227_b(OWNER, (Object)owner);
        this.field_70180_af.func_187227_b(DISGUISE_MODULE, (Object)new NBTTagCompound());
        this.field_70180_af.func_187227_b(ALLOWLIST, (Object)new NBTTagCompound());
        this.field_70180_af.func_187227_b(HAS_SPEED_MODULE, (Object)false);
        this.field_70180_af.func_187227_b(MODE, (Object)EnumSentryMode.CAMOUFLAGE_HP.ordinal());
        this.field_70180_af.func_187227_b(HEAD_ROTATION, (Object)Float.valueOf(0.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, (Object)new Owner());
        this.field_70180_af.func_187214_a(DISGUISE_MODULE, (Object)new NBTTagCompound());
        this.field_70180_af.func_187214_a(ALLOWLIST, (Object)new NBTTagCompound());
        this.field_70180_af.func_187214_a(HAS_SPEED_MODULE, (Object)false);
        this.field_70180_af.func_187214_a(MODE, (Object)EnumSentryMode.CAMOUFLAGE_HP.ordinal());
        this.field_70180_af.func_187214_a(HEAD_ROTATION, (Object)Float.valueOf(0.0f));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackRangedIfEnabled(this, this::getShootingSpeed, 10.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetNearestPlayerOrMob(this));
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            BlockPos downPos = this.func_180425_c().func_177977_b();
            IBlockState state = this.field_70170_p.func_180495_p(downPos);
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, downPos) || this.field_70170_p.func_184144_a(null, new AxisAlignedBB(downPos)).isEmpty()) {
                this.remove();
            }
        } else {
            if (!this.animate && this.headYTranslation > 0.0f && this.getMode().isAggressive()) {
                this.animateUpwards = true;
                this.animate = true;
            }
            if (this.animate) {
                if (this.animateUpwards && this.headYTranslation > 0.025f) {
                    this.headYTranslation -= 0.025f;
                    if (this.headYTranslation <= 0.025f) {
                        this.animateUpwards = false;
                        this.animate = false;
                    }
                } else if (!this.animateUpwards && this.headYTranslation < 0.9f) {
                    this.headYTranslation += 0.025f;
                    if (this.headYTranslation >= 0.9f) {
                        this.animateUpwards = true;
                        this.animate = false;
                    }
                }
            }
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(SCContent.sentry);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        BlockPos pos = this.func_180425_c();
        if (this.getOwner().isOwner(player) && hand == EnumHand.MAIN_HAND) {
            Item item = player.func_184614_ca().func_77973_b();
            player.func_71053_j();
            if (player.func_70093_af()) {
                this.remove();
            } else if (item == SCContent.universalBlockRemover) {
                this.remove();
                if (!player.func_184812_l_()) {
                    player.func_184614_ca().func_77972_a(1, (EntityLivingBase)player);
                }
            } else if (item == SCContent.disguiseModule) {
                ItemStack module = this.getDisguiseModule();
                if (!module.func_190926_b()) {
                    Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)module);
                    ArrayList<Block> blocks = ((ItemModule)module.func_77973_b()).getBlockAddons(module.func_77978_p());
                    if (blocks.size() > 0 && blocks.get(0) == this.field_70170_p.func_180495_p(pos).func_177230_c()) {
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    }
                }
                this.setDisguiseModule(player.func_184614_ca());
                if (!player.func_184812_l_()) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                }
            } else if (item == SCContent.allowlistModule) {
                ItemStack module = this.getAllowlistModule();
                if (!module.func_190926_b()) {
                    Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)module);
                }
                this.setAllowlistModule(player.func_184614_ca());
                if (!player.func_184812_l_()) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                }
            } else if (item == SCContent.speedModule) {
                if (!this.hasSpeedModule()) {
                    this.setHasSpeedModule(true);
                    if (!player.func_184812_l_()) {
                        player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                    }
                }
            } else if (item == SCContent.universalBlockModifier) {
                ArrayList<Block> blocks;
                if (!this.getDisguiseModule().func_190926_b() && (blocks = ((ItemModule)this.getDisguiseModule().func_77973_b()).getBlockAddons(this.getDisguiseModule().func_77978_p())).size() > 0 && blocks.get(0) == this.field_70170_p.func_180495_p(pos).func_177230_c()) {
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)this.getDisguiseModule());
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)this.getAllowlistModule());
                if (this.hasSpeedModule()) {
                    Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)new ItemStack((Item)SCContent.speedModule));
                }
                this.field_70180_af.func_187227_b(DISGUISE_MODULE, (Object)new NBTTagCompound());
                this.field_70180_af.func_187227_b(ALLOWLIST, (Object)new NBTTagCompound());
            } else if (item == SCContent.remoteAccessSentry) {
                item.func_180614_a(player, this.field_70170_p, pos, hand, EnumFacing.NORTH, 0.0f, 0.0f, 0.0f);
            } else if (item == Items.field_151057_cb) {
                this.func_96094_a(player.func_184614_ca().func_82833_r());
                player.func_184614_ca().func_190918_g(1);
            } else if (item == SCContent.universalOwnerChanger) {
                String newOwner;
                this.field_70180_af.func_187227_b(OWNER, (Object)new Owner(newOwner, PlayerUtils.isPlayerOnline(newOwner = player.func_184614_ca().func_82833_r()) ? PlayerUtils.getPlayerFromName(newOwner).func_110124_au().toString() : "ownerUUID"));
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:universalOwnerChanger.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), TextFormatting.GREEN);
            } else {
                this.toggleMode(player);
            }
            player.func_184609_a(EnumHand.MAIN_HAND);
            return true;
        }
        if (!this.getOwner().isOwner(player) && hand == EnumHand.MAIN_HAND && player.func_184812_l_() && (player.func_70093_af() || player.func_184614_ca().func_77973_b() == SCContent.universalBlockRemover)) {
            this.remove();
        }
        return super.func_184645_a(player, hand);
    }

    public void remove() {
        ArrayList<Block> blocks;
        BlockPos pos = this.func_180425_c();
        if (!this.getDisguiseModule().func_190926_b() && (blocks = ((ItemModule)this.getDisguiseModule().func_77973_b()).getBlockAddons(this.getDisguiseModule().func_77978_p())).size() > 0 && blocks.get(0) == this.field_70170_p.func_180495_p(pos).func_177230_c()) {
            this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)new ItemStack(SCContent.sentry));
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)this.getDisguiseModule());
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)this.getAllowlistModule());
        if (this.hasSpeedModule()) {
            Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)new ItemStack((Item)SCContent.speedModule));
        }
        this.func_70106_y();
    }

    public void func_174812_G() {
        this.remove();
    }

    public void toggleMode(EntityPlayer player) {
        this.toggleMode(player, (Integer)this.field_70180_af.func_187225_a(MODE) + 1, true);
    }

    public void toggleMode(EntityPlayer player, int mode, boolean sendMessage) {
        if (mode < 0 || mode >= EnumSentryMode.values().length) {
            mode = 0;
        }
        this.field_70180_af.func_187227_b(MODE, (Object)mode);
        if (sendMessage) {
            player.func_146105_b(Utils.localize(EnumSentryMode.values()[mode].getModeKey(), new Object[0]).func_150257_a((ITextComponent)Utils.localize(EnumSentryMode.values()[mode].getDescriptionKey(), new Object[0])), true);
        }
        if (!player.field_70170_p.field_72995_K) {
            SecurityCraft.network.sendToAll((IMessage)new InitSentryAnimation(this.func_180425_c(), true, EnumSentryMode.values()[mode].isAggressive()));
        }
    }

    public void func_70624_b(EntityLivingBase target) {
        if (!this.getMode().isAggressive() && (target == null && this.previousTargetId != Long.MIN_VALUE || target != null && this.previousTargetId != (long)target.func_145782_y())) {
            this.animateUpwards = this.getMode().isCamouflage() && target != null;
            this.animate = true;
            SecurityCraft.network.sendToAll((IMessage)new InitSentryAnimation(this.func_180425_c(), this.animate, this.animateUpwards));
        }
        this.previousTargetId = target == null ? Long.MIN_VALUE : (long)target.func_145782_y();
        super.func_70624_b(target);
    }

    public float func_70047_e() {
        return 1.5f;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (target instanceof EntityPlayer && (((EntityPlayer)target).func_175149_v() || ((EntityPlayer)target).func_184812_l_())) {
            return;
        }
        if (this.func_70068_e((Entity)target) > 400.0) {
            return;
        }
        TileEntity te = this.field_70170_p.func_175625_s(this.func_180425_c().func_177977_b());
        EntityBullet throwableEntity = null;
        SoundEvent shootSound = SoundEvents.field_187737_v;
        BehaviorProjectileDispense pdb = null;
        IItemHandler handler = null;
        if (te instanceof TileEntityKeypadChest) {
            handler = ((TileEntityKeypadChest)te).getHandlerForSentry(this);
        } else if (te != null) {
            handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        }
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                IBehaviorDispenseItem dispenseBehavior;
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b() || !((dispenseBehavior = ((BlockDispenser)Blocks.field_150367_z).func_149940_a(stack)) instanceof BehaviorProjectileDispense)) continue;
                ItemStack extracted = handler.extractItem(i, 1, false);
                Vec3d vec = this.func_174791_d();
                pdb = (BehaviorProjectileDispense)dispenseBehavior;
                throwableEntity = pdb.func_82499_a(this.field_70170_p, (IPosition)new PositionImpl(vec.field_72450_a, vec.field_72448_b + 1.6, vec.field_72449_c), extracted);
                if (throwableEntity instanceof EntityArrow) {
                    ((EntityArrow)throwableEntity).field_70250_c = this;
                } else if (throwableEntity instanceof EntityThrowable) {
                    ((EntityThrowable)throwableEntity).field_70192_c = this;
                }
                shootSound = null;
                break;
            }
        }
        if (throwableEntity == null) {
            throwableEntity = new EntityBullet(this.field_70170_p, this);
        }
        double baseY = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
        double x = target.field_70165_t - this.field_70165_t;
        double y = baseY - ((Entity)throwableEntity).field_70163_u;
        double z = target.field_70161_v - this.field_70161_v;
        float yOffset = MathHelper.func_76133_a((double)(x * x + z * z)) * 0.2f;
        this.field_70180_af.func_187227_b(HEAD_ROTATION, (Object)Float.valueOf((float)(MathHelper.func_181159_b((double)x, (double)(-z)) * 57.29577951308232)));
        throwableEntity.func_70186_c(x, y + (double)yOffset, z, 1.6f, 0.0f);
        if (shootSound == null) {
            pdb.func_82485_a((IBlockSource)new BlockSourceImpl(this.field_70170_p, this.func_180425_c()));
        } else {
            this.func_184185_a(shootSound, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
        Entity entity = (Entity)throwableEntity;
        WorldUtils.addScheduledTask(this.field_70170_p, () -> this.field_70170_p.func_72838_d(entity));
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74782_a("TileEntityData", (NBTBase)this.getOwnerTag());
        tag.func_74782_a("InstalledModule", (NBTBase)this.getDisguiseModule().func_77955_b(new NBTTagCompound()));
        tag.func_74782_a("InstalledWhitelist", (NBTBase)this.getAllowlistModule().func_77955_b(new NBTTagCompound()));
        tag.func_74757_a("HasSpeedModule", this.hasSpeedModule());
        tag.func_74768_a("SentryMode", ((Integer)this.field_70180_af.func_187225_a(MODE)).intValue());
        tag.func_74776_a("HeadRotation", ((Float)this.field_70180_af.func_187225_a(HEAD_ROTATION)).floatValue());
        super.func_70014_b(tag);
    }

    private NBTTagCompound getOwnerTag() {
        NBTTagCompound tag = new NBTTagCompound();
        Owner owner = (Owner)this.field_70180_af.func_187225_a(OWNER);
        tag.func_74778_a("owner", owner.getName());
        tag.func_74778_a("ownerUUID", owner.getUUID());
        return tag;
    }

    public void func_70037_a(NBTTagCompound tag) {
        NBTTagCompound teTag = tag.func_74775_l("TileEntityData");
        String name = teTag.func_74779_i("owner");
        String uuid = teTag.func_74779_i("ownerUUID");
        this.field_70180_af.func_187227_b(OWNER, (Object)new Owner(name, uuid));
        this.field_70180_af.func_187227_b(DISGUISE_MODULE, (Object)tag.func_74775_l("InstalledModule"));
        this.field_70180_af.func_187227_b(ALLOWLIST, (Object)tag.func_74775_l("InstalledWhitelist"));
        this.field_70180_af.func_187227_b(HAS_SPEED_MODULE, (Object)tag.func_74767_n("HasSpeedModule"));
        this.field_70180_af.func_187227_b(MODE, (Object)tag.func_74762_e("SentryMode"));
        this.field_70180_af.func_187227_b(HEAD_ROTATION, (Object)Float.valueOf(tag.func_74760_g("HeadRotation")));
        super.func_70037_a(tag);
    }

    public Owner getOwner() {
        return (Owner)this.field_70180_af.func_187225_a(OWNER);
    }

    public void setDisguiseModule(ItemStack module) {
        ArrayList<ItemStack> blocks = ((ItemModule)module.func_77973_b()).getAddons(module.func_77978_p());
        if (blocks.size() > 0) {
            ItemStack disguiseStack = (ItemStack)blocks.get(0);
            IBlockState state = Block.func_149634_a((Item)disguiseStack.func_77973_b()).func_176203_a(disguiseStack.func_77981_g() ? disguiseStack.func_77952_i() : 0);
            if (this.field_70170_p.func_175623_d(this.func_180425_c())) {
                this.field_70170_p.func_175656_a(this.func_180425_c(), state.func_185913_b() ? state : Blocks.field_150350_a.func_176223_P());
            }
        }
        this.field_70180_af.func_187227_b(DISGUISE_MODULE, (Object)module.func_77955_b(new NBTTagCompound()));
    }

    public void setAllowlistModule(ItemStack module) {
        this.field_70180_af.func_187227_b(ALLOWLIST, (Object)module.func_77955_b(new NBTTagCompound()));
    }

    public void setHasSpeedModule(boolean hasSpeedModule) {
        this.field_70180_af.func_187227_b(HAS_SPEED_MODULE, (Object)hasSpeedModule);
    }

    public ItemStack getDisguiseModule() {
        NBTTagCompound tag = (NBTTagCompound)this.field_70180_af.func_187225_a(DISGUISE_MODULE);
        if (tag == null || tag.func_82582_d()) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(tag);
    }

    public ItemStack getAllowlistModule() {
        NBTTagCompound tag = (NBTTagCompound)this.field_70180_af.func_187225_a(ALLOWLIST);
        if (tag == null || tag.func_82582_d()) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(tag);
    }

    public boolean hasSpeedModule() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_SPEED_MODULE);
    }

    public EnumSentryMode getMode() {
        int mode = (Integer)this.field_70180_af.func_187225_a(MODE);
        return mode < 0 || mode >= EnumSentryMode.values().length ? EnumSentryMode.CAMOUFLAGE_HP : EnumSentryMode.values()[mode];
    }

    public float getHeadYTranslation() {
        return this.headYTranslation;
    }

    public boolean isTargetingAllowedPlayer(EntityLivingBase potentialTarget) {
        if (potentialTarget != null) {
            List<String> players = ModuleUtils.getPlayersFromModule(this.getAllowlistModule());
            for (String s : players) {
                if (!potentialTarget.func_70005_c_().equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    public int getShootingSpeed() {
        return this.hasSpeedModule() ? 5 : 10;
    }

    public boolean func_70652_k(Entity entity) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_190631_cK() {
        return false;
    }

    public boolean func_70601_bi() {
        return false;
    }

    public void func_70664_aZ() {
    }

    public boolean func_70781_l() {
        return false;
    }

    protected void func_70623_bb() {
    }

    public void func_70100_b_(EntityPlayer entity) {
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
    }

    protected void func_82167_n(Entity entity) {
    }

    protected void func_85033_bc() {
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }

    public void func_110159_bB() {
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public Random func_70681_au() {
        return notRandom;
    }

    public static enum EnumSentryMode {
        CAMOUFLAGE_HP(1, 0, 1),
        CAMOUFLAGE_H(1, 1, 3),
        CAMOUFLAGE_P(1, 2, 5),
        AGGRESSIVE_HP(0, 0, 0),
        AGGRESSIVE_H(0, 1, 2),
        AGGRESSIVE_P(0, 2, 4),
        IDLE(-1, -1, 6);

        private final int type;
        private final int attack;
        private final int descriptionKeyIndex;

        private EnumSentryMode(int type, int attack, int descriptionKeyIndex) {
            this.type = type;
            this.attack = attack;
            this.descriptionKeyIndex = descriptionKeyIndex;
        }

        public boolean isAggressive() {
            return this.type == 0;
        }

        public boolean isCamouflage() {
            return this.type == 1;
        }

        public boolean attacksHostile() {
            return this.attack == 0 || this.attack == 1;
        }

        public boolean attacksPlayers() {
            return this.attack == 0 || this.attack == 2;
        }

        public String getModeKey() {
            String key = "messages.securitycraft:sentry.mode";
            return this.isAggressive() ? key + "0" : (this.isCamouflage() ? key + "1" : key + "2");
        }

        public String getTargetKey() {
            String key = "gui.securitycraft:srat.targets";
            return this.attacksHostile() && this.attacksPlayers() ? key + "1" : (this.attacksHostile() ? key + "2" : (this.attacksPlayers() ? key + "3" : ""));
        }

        public String getDescriptionKey() {
            return "messages.securitycraft:sentry.descriptionMode" + this.descriptionKeyIndex;
        }
    }

    private static class NotRandom
    extends Random {
        private NotRandom() {
        }

        @Override
        public int nextInt(int bound) {
            return 0;
        }
    }
}

