/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.ContainerGeneric;
import net.geforcemods.securitycraft.network.server.ClearLoggerServer;
import net.geforcemods.securitycraft.tileentity.TileEntityLogger;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiLogger
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
    private TileEntityLogger tileEntity;
    private PlayerList playerList;

    public GuiLogger(InventoryPlayer inventory, TileEntityLogger te) {
        super((Container)new ContainerGeneric(inventory, te));
        this.tileEntity = te;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.func_189646_b((GuiButton)new GuiButton((int)0, (int)(this.field_147003_i + 4), (int)(this.field_147009_r + 4), (int)8, (int)8, (String)"x")).field_146124_l = this.tileEntity.getOwner().isOwner((EntityPlayer)this.field_146297_k.field_71439_g);
        this.playerList = new PlayerList(this.field_146297_k, this.field_146999_f - 24, this.field_147000_g - 40, this.field_147009_r + 20, this.field_147003_i + 12, this.field_146294_l, this.field_146295_m);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.tileEntity.players = new String[100];
            SecurityCraft.network.sendToServer((IMessage)new ClearLoggerServer(this.tileEntity.func_174877_v()));
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int slotIndex;
        String localized = Utils.localize("gui.securitycraft:logger.logged", new Object[0]).func_150254_d();
        this.field_146289_q.func_78276_b(localized, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(localized) / 2, 6, 0x404040);
        if (mouseX >= this.field_147003_i + 4 && mouseY >= this.field_147009_r + 4 && mouseX < this.field_147003_i + 4 + 8 && mouseY < this.field_147009_r + 4 + 8) {
            this.func_146279_a(Utils.localize("gui.securitycraft:editModule.clear", new Object[0]).func_150254_d(), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if ((slotIndex = this.playerList.hoveredSlot) != -1 && this.tileEntity.players[slotIndex] != null && !this.tileEntity.players[slotIndex].isEmpty() && this.tileEntity.getOwner().isOwner((EntityPlayer)this.field_146297_k.field_71439_g)) {
            localized = Utils.localize("gui.securitycraft:logger.date", DATE_FORMAT.format(new Date(this.tileEntity.timestamps[slotIndex]))).func_150254_d();
            if (this.tileEntity.uuids[slotIndex] != null && !this.tileEntity.uuids[slotIndex].isEmpty()) {
                this.func_146279_a(this.tileEntity.uuids[slotIndex], mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
            this.field_146289_q.func_78276_b(localized, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(localized) / 2, this.field_147000_g - 15, 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.playerList != null) {
            this.playerList.drawScreen(mouseX, mouseY, partialTicks);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.playerList.handleMouseInput(mouseX, mouseY);
    }

    class PlayerList
    extends GuiScrollingList {
        private int hoveredSlot;
        private int i;
        private boolean isHovering;

        public PlayerList(Minecraft client, int width, int height, int top, int left, int screenWidth, int screenHeight) {
            super(client, width, height, top, top + height, left, 12, screenWidth, screenHeight);
            this.hoveredSlot = -1;
            this.i = 0;
            this.isHovering = false;
        }

        protected int getSize() {
            return ((GuiLogger)GuiLogger.this).tileEntity.players.length;
        }

        protected void elementClicked(int index, boolean doubleClick) {
            String uuid;
            if (GuiLogger.this.tileEntity.getOwner().isOwner((EntityPlayer)GuiLogger.this.field_146297_k.field_71439_g) && (uuid = ((GuiLogger)GuiLogger.this).tileEntity.uuids[index]) != null) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(uuid), null);
            }
        }

        protected boolean isSelected(int index) {
            return false;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIndex, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            if (this.mouseX >= this.left && this.mouseX <= entryRight && slotIndex >= 0 && slotIndex < this.getSize() && this.mouseY >= slotTop - 1 && this.mouseY <= slotTop + slotBuffer + 2 && ((GuiLogger)GuiLogger.this).tileEntity.players[slotIndex] != null && !((GuiLogger)GuiLogger.this).tileEntity.players[slotIndex].isEmpty()) {
                int min = this.left;
                int max = entryRight + 1;
                BufferBuilder bufferBuilder = tess.func_178180_c();
                this.hoveredSlot = slotIndex;
                this.isHovering = true;
                GlStateManager.func_179090_x();
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferBuilder.func_181662_b((double)min, (double)(slotTop + --slotBuffer + 3), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferBuilder.func_181662_b((double)max, (double)(slotTop + slotBuffer + 3), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferBuilder.func_181662_b((double)max, (double)(slotTop - 2), 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferBuilder.func_181662_b((double)min, (double)(slotTop - 2), 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferBuilder.func_181662_b((double)(min + 1), (double)(slotTop + slotBuffer + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferBuilder.func_181662_b((double)(max - 1), (double)(slotTop + slotBuffer + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferBuilder.func_181662_b((double)(max - 1), (double)(slotTop - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferBuilder.func_181662_b((double)(min + 1), (double)(slotTop - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tess.func_78381_a();
                GlStateManager.func_179098_w();
            }
            if (this.i++ == this.getSize() - 1) {
                if (!this.isHovering) {
                    this.hoveredSlot = -1;
                    this.i = 0;
                } else {
                    this.isHovering = false;
                    this.i = 0;
                }
            }
            if (slotIndex >= 0 && slotIndex < ((GuiLogger)GuiLogger.this).tileEntity.players.length && ((GuiLogger)GuiLogger.this).tileEntity.players[slotIndex] != null && !((GuiLogger)GuiLogger.this).tileEntity.players[slotIndex].equals("")) {
                GuiLogger.this.field_146289_q.func_78276_b(((GuiLogger)GuiLogger.this).tileEntity.players[slotIndex], GuiLogger.this.field_146294_l / 2 - GuiLogger.this.field_146289_q.func_78256_a(((GuiLogger)GuiLogger.this).tileEntity.players[slotIndex]) / 2, slotTop, 0xC6C6C6);
            }
        }
    }
}

