/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadChest;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SetPassword
implements IMessage {
    private String password;
    private int x;
    private int y;
    private int z;

    public SetPassword() {
    }

    public SetPassword(int x, int y, int z, String code) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.password = code;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.password);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.password = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<SetPassword, IMessage> {
        public IMessage onMessage(SetPassword message, MessageContext ctx) {
            WorldUtils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                BlockPos pos = new BlockPos(message.x, message.y, message.z);
                String password = message.password;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World world = player.field_70170_p;
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof IPasswordProtected && (!(te instanceof IOwnable) || ((IOwnable)te).getOwner().isOwner((EntityPlayer)player))) {
                    ((IPasswordProtected)te).setPassword(password);
                    if (te instanceof TileEntityKeypadChest) {
                        this.checkAndUpdateAdjacentChest(world, pos, password, (EntityPlayer)player);
                    }
                }
            });
            return null;
        }

        private void checkAndUpdateAdjacentChest(World world, BlockPos pos, String codeToSet, EntityPlayer player) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                BlockPos offsetPos = pos.func_177972_a(facing);
                TileEntity te = world.func_175625_s(offsetPos);
                if (!(te instanceof TileEntityKeypadChest)) continue;
                IBlockState state = world.func_180495_p(offsetPos);
                ((IPasswordProtected)te).setPassword(codeToSet);
                world.func_184138_a(offsetPos, state, state, 2);
                break;
            }
        }
    }
}

