/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.List;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.BlockClaymore;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TileEntityClaymore
extends CustomizableSCTE {
    private Option.OptionInt range = new Option.OptionInt(() -> ((TileEntityClaymore)this).func_174877_v(), "range", 5, 1, 10, 1, true);
    private double entityX = -1.0;
    private double entityY = -1.0;
    private double entityZ = -1.0;
    private int cooldown = -1;

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (((Boolean)state.func_177229_b((IProperty)BlockClaymore.DEACTIVATED)).booleanValue()) {
                return;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return;
            }
            if (this.cooldown == 0) {
                ((BlockClaymore)this.func_145838_q()).explode(this.field_145850_b, this.field_174879_c);
                return;
            }
            EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)BlockClaymore.FACING);
            AxisAlignedBB area = BlockUtils.fromBounds(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1);
            if (dir == EnumFacing.NORTH) {
                area = area.func_191195_a(0.0, 0.0, (double)((Integer)this.range.get()).intValue());
            } else if (dir == EnumFacing.SOUTH) {
                area = area.func_191195_a(0.0, 0.0, (double)(-((Integer)this.range.get()).intValue()));
            } else if (dir == EnumFacing.EAST) {
                area = area.func_191195_a((double)(-((Integer)this.range.get()).intValue()), 0.0, 0.0);
            } else if (dir == EnumFacing.WEST) {
                area = area.func_191195_a((double)((Integer)this.range.get()).intValue(), 0.0, 0.0);
            }
            List entities = this.func_145831_w().func_175647_a(EntityLivingBase.class, area, e -> !EntityUtils.isInvisible(e));
            for (EntityLivingBase entity : entities) {
                if (PlayerUtils.isPlayerMountedOnCamera(entity) || EntityUtils.doesEntityOwn((Entity)entity, this.field_145850_b, this.field_174879_c)) continue;
                this.entityX = entity.field_70165_t;
                this.entityY = entity.field_70163_u;
                this.entityZ = entity.field_70161_v;
                this.cooldown = 20;
                for (EntityPlayer player : this.func_145831_w().field_73010_i) {
                    this.func_145831_w().func_184133_a(player, new BlockPos((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f);
                }
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeOptions(tag);
        tag.func_74768_a("cooldown", this.cooldown);
        tag.func_74780_a("entityX", this.entityX);
        tag.func_74780_a("entityY", this.entityY);
        tag.func_74780_a("entityZ", this.entityZ);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readOptions(tag);
        this.cooldown = tag.func_74762_e("cooldown");
        this.entityX = tag.func_74769_h("entityX");
        this.entityY = tag.func_74769_h("entityY");
        this.entityZ = tag.func_74769_h("entityZ");
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range};
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[0];
    }
}

