/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockInventoryScanner;
import net.geforcemods.securitycraft.blocks.BlockInventoryScannerField;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileEntityInventoryScanner
extends TileEntityDisguisable
implements IInventory {
    private Option.OptionBoolean horizontal = new Option.OptionBoolean("horizontal", false);
    private Option.OptionBoolean solidifyField = new Option.OptionBoolean("solidifyField", false);
    private static final EmptyHandler EMPTY_INVENTORY = new EmptyHandler();
    private NonNullList<ItemStack> inventoryContents = NonNullList.func_191197_a((int)37, (Object)ItemStack.field_190927_a);
    private boolean isProvidingPower;
    private int cooldown;

    @Override
    public void func_73660_a() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else if (this.isProvidingPower) {
            this.isProvidingPower = false;
            BlockUtils.updateAndNotify(this.func_145831_w(), this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c(), 1, true);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList list = tag.func_150295_c("Items", 10);
        this.inventoryContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            int slot = stackTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.inventoryContents.size()) continue;
            this.inventoryContents.set(slot, (Object)new ItemStack(stackTag));
        }
        this.cooldown = tag.func_74762_e("cooldown");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventoryContents.size(); ++i) {
            if (((ItemStack)this.inventoryContents.get(i)).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventoryContents.get(i)).func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Items", (NBTBase)list);
        tag.func_74768_a("cooldown", this.cooldown);
        return tag;
    }

    public int func_70302_i_() {
        return 37;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (!((ItemStack)this.inventoryContents.get(index)).func_190926_b()) {
            if (((ItemStack)this.inventoryContents.get(index)).func_190916_E() <= count) {
                ItemStack stack = (ItemStack)this.inventoryContents.get(index);
                this.inventoryContents.set(index, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return stack;
            }
            ItemStack stack = ((ItemStack)this.inventoryContents.get(index)).func_77979_a(count);
            if (((ItemStack)this.inventoryContents.get(index)).func_190916_E() == 0) {
                this.inventoryContents.set(index, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (ItemStack)this.inventoryContents.get(slot);
    }

    public ItemStack getStackInSlotCopy(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public void addItemToStorage(ItemStack stack) {
        ItemStack remainder = stack;
        for (int i = 10; i < this.getContents().size() && !(remainder = this.insertItem(i, remainder)).func_190926_b(); ++i) {
        }
    }

    public ItemStack insertItem(int slot, ItemStack stackToInsert) {
        if (stackToInsert.func_190926_b() || slot < 0 || slot >= this.getContents().size()) {
            return stackToInsert;
        }
        ItemStack slotStack = this.func_70301_a(slot);
        int limit = stackToInsert.func_77973_b().getItemStackLimit(stackToInsert);
        if (slotStack.func_190926_b()) {
            this.func_70299_a(slot, stackToInsert);
            return ItemStack.field_190927_a;
        }
        if (BlockInventoryScannerField.areItemStacksEqual(slotStack, stackToInsert) && slotStack.func_190916_E() < limit) {
            if (limit - slotStack.func_190916_E() >= stackToInsert.func_190916_E()) {
                slotStack.func_190920_e(slotStack.func_190916_E() + stackToInsert.func_190916_E());
                return ItemStack.field_190927_a;
            }
            ItemStack toInsert = stackToInsert.func_77946_l();
            ItemStack toReturn = toInsert.func_77979_a(slotStack.func_190916_E() + stackToInsert.func_190916_E() - limit);
            slotStack.func_190920_e(slotStack.func_190916_E() + toInsert.func_190916_E());
            return toReturn;
        }
        return stackToInsert;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)EMPTY_INVENTORY;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    public boolean shouldProvidePower() {
        return this.hasModule(EnumModuleType.REDSTONE) && this.isProvidingPower;
    }

    public void setShouldProvidePower(boolean isProvidingPower) {
        this.isProvidingPower = isProvidingPower;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public NonNullList<ItemStack> getContents() {
        return this.inventoryContents;
    }

    public void setContents(NonNullList<ItemStack> contents) {
        this.inventoryContents = contents;
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumModuleType module) {
        super.onModuleInserted(stack, module);
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(this.field_145850_b, this.field_174879_c);
        if (connectedScanner != null && !connectedScanner.hasModule(module)) {
            connectedScanner.insertModule(stack);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumModuleType module) {
        super.onModuleRemoved(stack, module);
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(this.field_145850_b, this.field_174879_c);
        if (connectedScanner != null && connectedScanner.hasModule(module)) {
            connectedScanner.removeModule(module);
        }
        if (module == EnumModuleType.STORAGE) {
            int i;
            for (i = 10; i < this.func_70302_i_(); ++i) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)((ItemStack)this.getContents().get(i)));
            }
            if (connectedScanner != null) {
                for (i = 0; i < connectedScanner.getContents().size(); ++i) {
                    connectedScanner.getContents().set(i, (Object)ItemStack.field_190927_a);
                }
            }
        }
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.ALLOWLIST, EnumModuleType.SMART, EnumModuleType.STORAGE, EnumModuleType.DISGUISE, EnumModuleType.REDSTONE};
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        if (option.getName().equals("horizontal")) {
            Option.OptionBoolean bo = (Option.OptionBoolean)option;
            TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(this.field_145850_b, this.field_174879_c);
            IBlockState thisState = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (connectedScanner != null) {
                EnumFacing facing = (EnumFacing)thisState.func_177229_b((IProperty)BlockInventoryScanner.FACING);
                for (int i = 0; i <= ConfigHandler.inventoryScannerRange; ++i) {
                    BlockPos offsetPos = this.field_174879_c.func_177967_a(facing, i);
                    IBlockState state = this.field_145850_b.func_180495_p(offsetPos);
                    Block block = state.func_177230_c();
                    if (block == SCContent.inventoryScannerField) {
                        this.field_145850_b.func_175656_a(offsetPos, state.func_177226_a((IProperty)BlockInventoryScannerField.HORIZONTAL, (Comparable)bo.get()));
                        continue;
                    }
                    if (!block.isAir(thisState, (IBlockAccess)this.field_145850_b, offsetPos) && block != SCContent.inventoryScannerField && block != SCContent.inventoryScanner || block == SCContent.inventoryScanner && state.func_177229_b((IProperty)BlockInventoryScanner.FACING) == facing.func_176734_d()) break;
                }
                connectedScanner.setHorizontal((Boolean)bo.get());
            }
            this.field_145850_b.func_175656_a(this.field_174879_c, thisState.func_177226_a((IProperty)BlockInventoryScanner.HORIZONTAL, (Comparable)bo.get()));
        } else if (option.getName().equals("solidifyField")) {
            Option.OptionBoolean bo = (Option.OptionBoolean)option;
            TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(this.field_145850_b, this.field_174879_c);
            connectedScanner.setSolidifyField((Boolean)bo.get());
        }
    }

    public void setHorizontal(boolean isHorizontal) {
        this.horizontal.setValue(isHorizontal);
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockInventoryScanner.HORIZONTAL, (Comparable)Boolean.valueOf(isHorizontal)));
    }

    public boolean isHorizontal() {
        return (Boolean)this.horizontal.get();
    }

    public boolean doesFieldSolidify() {
        return (Boolean)this.solidifyField.get();
    }

    public void setSolidifyField(boolean shouldSolidify) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.solidifyField.setValue(shouldSolidify);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.horizontal, this.solidifyField};
    }

    public void func_174888_l() {
        this.inventoryContents.clear();
    }

    public boolean func_191420_l() {
        return this.inventoryContents.isEmpty();
    }

    public ItemStack func_70304_b(int index) {
        return (ItemStack)this.inventoryContents.remove(index);
    }

    public String func_70005_c_() {
        return SCContent.inventoryScanner.func_149732_F();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }
}

