/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class TileEntityLaserBlock
extends TileEntityDisguisable {
    private Option.OptionBoolean enabledOption = new Option.OptionBoolean("enabled", true){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            TileEntityLaserBlock.this.toggleLaser(this);
        }
    };

    private void toggleLaser(Option.OptionBoolean option) {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block != SCContent.laserBlock) {
            return;
        }
        if (((Boolean)option.get()).booleanValue()) {
            ((BlockLaserBlock)block).setLaser(((TileEntityLaserBlock)this.field_145850_b.func_175625_s(this.field_174879_c)).getOwner(), this.field_145850_b, this.field_174879_c);
        } else {
            BlockLaserBlock.destroyAdjacentLasers(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    protected void onLinkedBlockAction(EnumLinkedAction action, Object[] parameters, ArrayList<CustomizableSCTE> excludedTEs) {
        if (action == EnumLinkedAction.OPTION_CHANGED) {
            Option option = (Option)parameters[0];
            this.enabledOption.copy(option);
            this.toggleLaser((Option.OptionBoolean)option);
            excludedTEs.add(this);
            this.createLinkedBlockAction(EnumLinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, excludedTEs);
        } else if (action == EnumLinkedAction.MODULE_INSERTED) {
            ItemStack module = (ItemStack)parameters[0];
            this.insertModule(module);
            excludedTEs.add(this);
            this.createLinkedBlockAction(EnumLinkedAction.MODULE_INSERTED, parameters, excludedTEs);
        } else if (action == EnumLinkedAction.MODULE_REMOVED) {
            EnumModuleType module = (EnumModuleType)((Object)parameters[1]);
            this.removeModule(module);
            excludedTEs.add(this);
            this.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, parameters, excludedTEs);
        }
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.HARMING, EnumModuleType.ALLOWLIST, EnumModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.enabledOption};
    }

    public boolean isEnabled() {
        return (Boolean)this.enabledOption.get();
    }
}

