/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.network.client.ClearLoggerClient;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityLogger
extends TileEntityDisguisable {
    private Option.OptionInt searchRadius = new Option.OptionInt(() -> ((TileEntityLogger)this).func_174877_v(), "searchRadius", 3, 1, 20, 1, true);
    public String[] players = new String[100];
    public String[] uuids = new String[100];
    public long[] timestamps = new long[100];

    @Override
    public boolean attackEntity(Entity entity) {
        if (!this.field_145850_b.field_72995_K && entity instanceof EntityPlayer) {
            this.addPlayer((EntityPlayer)entity);
            this.sendChangeToClient(false);
        }
        return true;
    }

    @Override
    public boolean canAttack() {
        return this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
    }

    public void logPlayers() {
        int range = (Integer)this.searchRadius.get();
        AxisAlignedBB area = BlockUtils.fromBounds(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1).func_72314_b((double)range, (double)range, (double)range);
        List entities = this.field_145850_b.func_72872_a(EntityPlayer.class, area);
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            this.addPlayer((EntityPlayer)iterator.next());
        }
        this.sendChangeToClient(false);
    }

    private void addPlayer(EntityPlayer player) {
        String playerName = player.func_70005_c_();
        long timestamp = System.currentTimeMillis();
        if (!(this.getOwner().isOwner(player) || EntityUtils.isInvisible((EntityLivingBase)player) || this.hasPlayerName(playerName, timestamp))) {
            if (ModuleUtils.isAllowed((IModuleInventory)this, (Entity)player)) {
                return;
            }
            for (int i = 0; i < this.players.length; ++i) {
                if (this.players[i] != null && !this.players[i].equals("")) continue;
                this.players[i] = player.func_70005_c_();
                this.uuids[i] = player.func_146103_bH().getId().toString();
                this.timestamps[i] = timestamp;
                break;
            }
        }
    }

    private boolean hasPlayerName(String username, long timestamp) {
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] == null || !this.players[i].equals(username) || this.timestamps[i] + 1000L <= timestamp) continue;
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        for (int i = 0; i < this.players.length; ++i) {
            tag.func_74778_a("player" + i, this.players[i] == null ? "" : this.players[i]);
            tag.func_74778_a("uuid" + i, this.uuids[i] == null ? "" : this.uuids[i]);
            tag.func_74772_a("timestamp" + i, this.timestamps[i]);
        }
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < this.players.length; ++i) {
            this.players[i] = tag.func_74779_i("player" + i);
            this.uuids[i] = tag.func_74779_i("uuid" + i);
            this.timestamps[i] = tag.func_74763_f("timestamp" + i);
        }
    }

    public void sendChangeToClient(boolean clear) {
        if (!clear) {
            for (int i = 0; i < this.players.length; ++i) {
                if (this.players[i] == null) continue;
                SecurityCraft.network.sendToAll((IMessage)new UpdateLogger(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), i, this.players[i], this.uuids[i], this.timestamps[i]));
            }
        } else {
            SecurityCraft.network.sendToAll((IMessage)new ClearLoggerClient(this.field_174879_c));
        }
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.DISGUISE, EnumModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadius};
    }
}

