/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.List;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockPortableRadar;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class TileEntityPortableRadar
extends CustomizableSCTE {
    private Option.OptionDouble searchRadiusOption = new Option.OptionDouble(() -> ((TileEntityPortableRadar)this).func_174877_v(), "searchRadius", 25.0, 5.0, 50.0, 1.0, true);
    private Option.OptionInt searchDelayOption = new Option.OptionInt(() -> ((TileEntityPortableRadar)this).func_174877_v(), "searchDelay", 4, 4, 10, 1, true);
    private Option.OptionBoolean repeatMessageOption = new Option.OptionBoolean("repeatMessage", true);
    private Option.OptionBoolean enabledOption = new Option.OptionBoolean("enabled", true);
    private boolean shouldSendNewMessage = true;
    private String lastPlayerName = "";
    private int ticksUntilNextSearch = this.getSearchDelay();

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && ((Boolean)this.enabledOption.get()).booleanValue() && this.ticksUntilNextSearch-- <= 0) {
            this.ticksUntilNextSearch = this.getSearchDelay();
            EntityPlayerMP owner = this.field_145850_b.func_73046_m().func_184103_al().func_152612_a(this.getOwner().getName());
            AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c).func_72314_b(this.getSearchRadius(), this.getSearchRadius(), this.getSearchRadius());
            List entities = this.field_145850_b.func_175647_a(EntityPlayer.class, area, e -> {
                boolean isNotAllowed = true;
                if (this.hasModule(EnumModuleType.ALLOWLIST)) {
                    isNotAllowed = !ModuleUtils.isAllowed((IModuleInventory)this, (Entity)e);
                }
                return e != owner && isNotAllowed && !e.func_175149_v() && !EntityUtils.isInvisible((EntityLivingBase)e);
            });
            if (this.hasModule(EnumModuleType.REDSTONE)) {
                BlockPortableRadar.togglePowerOutput(this.field_145850_b, this.field_174879_c, !entities.isEmpty());
            }
            if (owner != null) {
                for (EntityPlayer e2 : entities) {
                    if (!this.shouldSendMessage(e2)) continue;
                    PlayerUtils.sendMessageToPlayer((EntityPlayer)owner, (ITextComponent)Utils.localize("tile.securitycraft:portableRadar.name", new Object[0]), (ITextComponent)(this.hasCustomName() ? Utils.localize("messages.securitycraft:portableRadar.withName", TextFormatting.ITALIC + e2.func_70005_c_() + TextFormatting.RESET, TextFormatting.ITALIC + this.getCustomName() + TextFormatting.RESET) : Utils.localize("messages.securitycraft:portableRadar.withoutName", TextFormatting.ITALIC + e2.func_70005_c_() + TextFormatting.RESET, this.field_174879_c)), TextFormatting.BLUE);
                    this.setSentMessage();
                }
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumModuleType module) {
        super.onModuleRemoved(stack, module);
        if (module == EnumModuleType.REDSTONE) {
            BlockPortableRadar.togglePowerOutput(this.field_145850_b, this.field_174879_c, false);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("shouldSendNewMessage", this.shouldSendNewMessage);
        tag.func_74778_a("lastPlayerName", this.lastPlayerName);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.shouldSendNewMessage = tag.func_74767_n("shouldSendNewMessage");
        this.lastPlayerName = tag.func_74779_i("lastPlayerName");
    }

    public boolean shouldSendMessage(EntityPlayer player) {
        if (!player.func_70005_c_().equals(this.lastPlayerName)) {
            this.shouldSendNewMessage = true;
            this.lastPlayerName = player.func_70005_c_();
        }
        return (this.shouldSendNewMessage || (Boolean)this.repeatMessageOption.get() != false) && !player.func_70005_c_().equals(this.getOwner().getName());
    }

    public void setSentMessage() {
        this.shouldSendNewMessage = false;
    }

    public double getSearchRadius() {
        return (Double)this.searchRadiusOption.get();
    }

    public int getSearchDelay() {
        return (Integer)this.searchDelayOption.get() * 20;
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.REDSTONE, EnumModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadiusOption, this.searchDelayOption, this.repeatMessageOption, this.enabledOption};
    }
}

