/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.NonNullList;

public class TileEntitySecretSign
extends TileEntitySign
implements IOwnable,
IModuleInventory,
ICustomizable {
    private Owner owner = new Owner();
    private Option.OptionBoolean isSecret = new Option.OptionBoolean("isSecret", true);
    private NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeModuleInventory(tag);
        this.writeOptions(tag);
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner.getName());
            tag.func_74778_a("ownerUUID", this.owner.getUUID());
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.modules = this.readModuleInventory(tag);
        this.readOptions(tag);
        this.owner.setOwnerName(tag.func_74779_i("owner"));
        this.owner.setOwnerUUID(tag.func_74779_i("ownerUUID"));
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isSecret};
    }

    public boolean isSecret() {
        return (Boolean)this.isSecret.get();
    }

    public boolean isPlayerAllowedToSeeText(EntityPlayer player) {
        return !this.isSecret() || this.getOwner().isOwner(player) || ModuleUtils.isAllowed((IModuleInventory)this, (Entity)player);
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }
}

