/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class BlockUtils {
    private static final IItemHandler EMPTY_INVENTORY = new EmptyHandler();

    public static void updateAndNotify(World world, BlockPos pos, Block block, int delay, boolean shouldUpdate) {
        if (shouldUpdate) {
            world.func_175684_a(pos, block, delay);
        }
        world.func_175685_c(pos, block, false);
    }

    public static AxisAlignedBB fromBounds(double x1, double y1, double z1, double x2, double y2, double z2) {
        double d6 = Math.min(x1, x2);
        double d7 = Math.min(y1, y2);
        double d8 = Math.min(z1, z2);
        double d9 = Math.max(x1, x2);
        double d10 = Math.max(y1, y2);
        double d11 = Math.max(z1, z2);
        return new AxisAlignedBB(d6, d7, d8, d9, d10, d11);
    }

    public static int[] posToIntArray(BlockPos pos) {
        return new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
    }

    public static boolean hasActiveSCBlockNextTo(World world, BlockPos pos) {
        return SecurityCraftAPI.getRegisteredDoorActivators().stream().anyMatch(activator -> BlockUtils.hasActiveSCBlockNextTo(world, pos, world.func_175625_s(pos), activator));
    }

    private static boolean hasActiveSCBlockNextTo(World world, BlockPos pos, TileEntity te, IDoorActivator activator) {
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            IBlockState offsetState = world.func_180495_p(offsetPos);
            if (activator.getBlocks().contains(offsetState.func_177230_c())) {
                TileEntity offsetTe = world.func_175625_s(offsetPos);
                return activator.isPowering(world, offsetPos, offsetState, offsetTe) && (!(offsetTe instanceof IOwnable) || ((IOwnable)offsetTe).getOwner().owns((IOwnable)te));
            }
            if (world.func_175651_c(offsetPos, facing) != 15 || offsetState.func_185897_m()) continue;
            for (EnumFacing dirOffset : EnumFacing.values()) {
                if (dirOffset.func_176734_d() == facing) continue;
                BlockPos newOffsetPos = offsetPos.func_177972_a(dirOffset);
                offsetState = world.func_180495_p(newOffsetPos);
                if (!activator.getBlocks().contains(offsetState.func_177230_c())) continue;
                if (offsetState.func_177227_a().contains(BlockLever.field_176360_a) ? dirOffset != ((BlockLever.EnumOrientation)offsetState.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c() : offsetState.func_177227_a().contains(BlockDirectional.field_176387_N) && dirOffset != offsetState.func_177229_b((IProperty)BlockDirectional.field_176387_N)) {
                    return false;
                }
                TileEntity offsetTe = world.func_175625_s(newOffsetPos);
                return activator.isPowering(world, newOffsetPos, offsetState, offsetTe) && (!(offsetTe instanceof IOwnable) || ((IOwnable)offsetTe).getOwner().owns((IOwnable)te));
            }
        }
        return false;
    }

    public static <T> T getProtectedCapability(EnumFacing side, TileEntity te, Supplier<T> extractionPermittedHandler, Supplier<T> insertOnlyHandler) {
        if (side == null) {
            return (T)EMPTY_INVENTORY;
        }
        BlockPos offsetPos = te.func_174877_v().func_177972_a(side);
        IBlockState offsetState = te.func_145831_w().func_180495_p(offsetPos);
        for (IExtractionBlock extractionBlock : SecurityCraftAPI.getRegisteredExtractionBlocks()) {
            if (offsetState.func_177230_c() != extractionBlock.getBlock()) continue;
            if (!extractionBlock.canExtract((IOwnable)te, te.func_145831_w(), offsetPos, offsetState)) {
                return (T)EMPTY_INVENTORY;
            }
            return extractionPermittedHandler.get();
        }
        return insertOnlyHandler.get();
    }

    public static boolean isWithinUsableDistance(World world, BlockPos pos, EntityPlayer player, Block block) {
        return world.func_180495_p(pos).func_177230_c() == block && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }
}

