/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.Arrays;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GuiUtils {
    public static ResourceLocation cameraDashboard = new ResourceLocation("securitycraft:textures/gui/camera/camera_dashboard.png");
    public static ResourceLocation potionIcons = new ResourceLocation("minecraft:textures/gui/container/inventory.png");
    private static RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
    private static final ItemStack REDSTONE = new ItemStack(Items.field_151137_ax);
    private static final ResourceLocation[] MODULE_TEXTURES = new ResourceLocation[]{new ResourceLocation("securitycraft", "textures/items/module_background.png"), new ResourceLocation("securitycraft", "textures/items/whitelist_module.png"), new ResourceLocation("securitycraft", "textures/items/blacklist_module.png"), new ResourceLocation("securitycraft", "textures/items/harming_module.png"), new ResourceLocation("securitycraft", "textures/items/smart_module.png"), new ResourceLocation("securitycraft", "textures/items/storage_module.png"), new ResourceLocation("securitycraft", "textures/items/disguise_module.png"), new ResourceLocation("securitycraft", "textures/items/module_background.png")};
    private static final ResourceLocation REDSTONE_TEXTURE = new ResourceLocation("textures/items/redstone_dust.png");
    private static final ResourceLocation SUGAR_TEXTURE = new ResourceLocation("textures/items/sugar.png");

    public static void drawCameraOverlay(Minecraft mc, Gui gui, ScaledResolution resolution, EntityPlayer player, World world, BlockPos pos) {
        TileEntitySecurityCamera te = (TileEntitySecurityCamera)world.func_175625_s(pos);
        int timeY = 25;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        String lookAround = GameSettings.func_74298_c((int)settings.field_74351_w.func_151463_i()) + GameSettings.func_74298_c((int)settings.field_74370_x.func_151463_i()) + GameSettings.func_74298_c((int)settings.field_74368_y.func_151463_i()) + GameSettings.func_74298_c((int)settings.field_74366_z.func_151463_i()) + " - " + Utils.localize("gui.securitycraft:camera.lookAround", new Object[0]).func_150254_d();
        if (te.hasCustomName()) {
            String cameraName = te.getCustomName();
            Minecraft.func_71410_x().field_71466_p.func_175063_a(cameraName, (float)(resolution.func_78326_a() - Minecraft.func_71410_x().field_71466_p.func_78256_a(cameraName) - 8), 25.0f, 0xFFFFFF);
            timeY += 10;
        }
        Minecraft.func_71410_x().field_71466_p.func_175063_a(ClientUtils.getFormattedMinecraftTime(), (float)(resolution.func_78326_a() - Minecraft.func_71410_x().field_71466_p.func_78256_a(ClientUtils.getFormattedMinecraftTime()) - 8), (float)timeY, 0xFFFFFF);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(lookAround, (float)(resolution.func_78326_a() - Minecraft.func_71410_x().field_71466_p.func_78256_a(lookAround) - 8), (float)(resolution.func_78328_b() - 80), 0xFFFFFF);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(GameSettings.func_74298_c((int)settings.field_74311_E.func_151463_i()) + " - " + Utils.localize("gui.securitycraft:camera.exit", new Object[0]).func_150254_d(), (float)(resolution.func_78326_a() - Minecraft.func_71410_x().field_71466_p.func_78256_a(GameSettings.func_74298_c((int)settings.field_74311_E.func_151463_i()) + " - " + Utils.localize("gui.securitycraft:camera.exit", new Object[0]).func_150254_d()) - 8), (float)(resolution.func_78328_b() - 70), 0xFFFFFF);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(GameSettings.func_74298_c((int)KeyBindings.cameraZoomIn.func_151463_i()) + "/" + GameSettings.func_74298_c((int)KeyBindings.cameraZoomOut.func_151463_i()) + " - " + Utils.localize("gui.securitycraft:camera.zoom", new Object[0]).func_150254_d(), (float)(resolution.func_78326_a() - Minecraft.func_71410_x().field_71466_p.func_78256_a(GameSettings.func_74298_c((int)KeyBindings.cameraZoomIn.func_151463_i()) + "/" + GameSettings.func_74298_c((int)KeyBindings.cameraZoomOut.func_151463_i()) + " - " + Utils.localize("gui.securitycraft:camera.zoom", new Object[0]).func_150254_d()) - 8), (float)(resolution.func_78328_b() - 60), 0xFFFFFF);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(GameSettings.func_74298_c((int)KeyBindings.cameraActivateNightVision.func_151463_i()) + " - " + Utils.localize("gui.securitycraft:camera.activateNightVision", new Object[0]).func_150254_d(), (float)(resolution.func_78326_a() - Minecraft.func_71410_x().field_71466_p.func_78256_a(GameSettings.func_74298_c((int)KeyBindings.cameraActivateNightVision.func_151463_i()) + " - " + Utils.localize("gui.securitycraft:camera.activateNightVision", new Object[0]).func_150254_d()) - 8), (float)(resolution.func_78328_b() - 50), 0xFFFFFF);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(GameSettings.func_74298_c((int)KeyBindings.cameraEmitRedstone.func_151463_i()) + " - " + Utils.localize("gui.securitycraft:camera.toggleRedstone", new Object[0]).func_150254_d(), (float)(resolution.func_78326_a() - Minecraft.func_71410_x().field_71466_p.func_78256_a(GameSettings.func_74298_c((int)KeyBindings.cameraEmitRedstone.func_151463_i()) + " - " + Utils.localize("gui.securitycraft:camera.toggleRedstone", new Object[0]).func_150254_d()) - 8), (float)(resolution.func_78328_b() - 40), te.hasModule(EnumModuleType.REDSTONE) ? 0xFFFFFF : 0xFF3377);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(Utils.localize("gui.securitycraft:camera.toggleRedstoneNote", new Object[0]).func_150254_d(), (float)(resolution.func_78326_a() - Minecraft.func_71410_x().field_71466_p.func_78256_a(Utils.localize("gui.securitycraft:camera.toggleRedstoneNote", new Object[0]).func_150254_d()) - 8), (float)(resolution.func_78328_b() - 30), te.hasModule(EnumModuleType.REDSTONE) ? 0xFFFFFF : 0xFF3377);
        mc.func_110434_K().func_110577_a(cameraDashboard);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.func_73729_b(5, 0, 0, 0, 90, 20);
        gui.func_73729_b(resolution.func_78326_a() - 55, 5, 205, 0, 50, 30);
        if (player.func_70660_b(Potion.func_180142_b((String)"night_vision")) == null) {
            gui.func_73729_b(28, 4, 90, 12, 16, 11);
        } else {
            mc.func_110434_K().func_110577_a(potionIcons);
            gui.func_73729_b(25, 2, 70, 218, 19, 16);
            mc.func_110434_K().func_110577_a(cameraDashboard);
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185911_a((IBlockAccess)world, pos, (EnumFacing)state.func_177229_b((IProperty)BlockSecurityCamera.FACING)) == 0) {
            if (!te.hasModule(EnumModuleType.REDSTONE)) {
                gui.func_73729_b(12, 2, 104, 0, 12, 12);
            } else {
                gui.func_73729_b(12, 3, 90, 0, 12, 11);
            }
        } else {
            GuiUtils.drawItemStackToGui(REDSTONE, 10, 0, false);
        }
    }

    public static void drawItemStackToGui(ItemStack stack, int x, int y, boolean fixLighting) {
        if (fixLighting) {
            GlStateManager.func_179145_e();
        }
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        itemRender.func_180450_b(stack, x, y);
        itemRender.func_175030_a(Minecraft.func_71410_x().field_71466_p, stack, x, y);
        GlStateManager.func_179140_f();
        GlStateManager.func_179101_C();
    }

    public static void renderModuleInfo(EnumModuleType module, String moduleTooltip, String noModuleTooltip, boolean isModuleInstalled, int moduleLeft, int moduleTop, int screenWidth, int screenHeight, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        float alpha = isModuleInstalled ? 1.0f : 0.5f;
        int moduleRight = moduleLeft + 16;
        int moduleBottom = moduleTop + 16;
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        mc.func_110434_K().func_110577_a(MODULE_TEXTURES[module.ordinal()]);
        GuiUtils.drawTexture(Tessellator.func_178181_a(), moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        if (module == EnumModuleType.REDSTONE) {
            mc.func_110434_K().func_110577_a(REDSTONE_TEXTURE);
            GuiUtils.drawTexture(Tessellator.func_178181_a(), moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        } else if (module == EnumModuleType.SPEED) {
            mc.func_110434_K().func_110577_a(SUGAR_TEXTURE);
            GuiUtils.drawTexture(Tessellator.func_178181_a(), moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        }
        if (mouseX >= moduleLeft && mouseX < moduleRight && mouseY >= moduleTop && mouseY <= moduleBottom) {
            String text;
            String string = text = isModuleInstalled ? moduleTooltip : noModuleTooltip;
            if (text != null && !text.isEmpty()) {
                net.minecraftforge.fml.client.config.GuiUtils.drawHoveringText(Arrays.asList(text), (int)mouseX, (int)mouseY, (int)screenWidth, (int)screenHeight, (int)-1, (FontRenderer)mc.field_71466_p);
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179145_e();
    }

    private static void drawTexture(Tessellator tess, int moduleLeft, int moduleTop, int moduleRight, int moduleBottom, float alpha) {
        BufferBuilder bufferBuilder = tess.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferBuilder.func_181662_b((double)moduleLeft, (double)moduleBottom, 0.0).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferBuilder.func_181662_b((double)moduleRight, (double)moduleBottom, 0.0).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferBuilder.func_181662_b((double)moduleRight, (double)moduleTop, 0.0).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferBuilder.func_181662_b((double)moduleLeft, (double)moduleTop, 0.0).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tess.func_78381_a();
    }
}

