/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.List;
import net.geforcemods.securitycraft.entity.EntitySecurityCamera;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerUtils {
    public static EntityPlayer getPlayerFromName(String name) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            List players = Minecraft.func_71410_x().field_71441_e.field_73010_i;
            for (EntityPlayer tempPlayer : players) {
                if (!tempPlayer.func_70005_c_().equals(name)) continue;
                return tempPlayer;
            }
            return null;
        }
        List players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
        for (EntityPlayer tempPlayer : players) {
            if (!tempPlayer.func_70005_c_().equals(name)) continue;
            return tempPlayer;
        }
        return null;
    }

    public static boolean isPlayerOnline(String name) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            for (int i = 0; i < Minecraft.func_71410_x().field_71441_e.field_73010_i.size(); ++i) {
                EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().field_71441_e.field_73010_i.get(i);
                if (player == null || !player.func_70005_c_().equals(name)) continue;
                return true;
            }
            return false;
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(name) != null;
    }

    public static void sendMessageToPlayer(EntityPlayer player, ITextComponent prefix, ITextComponent text, TextFormatting color) {
        PlayerUtils.sendMessageToPlayer(player, prefix, text, color, false);
    }

    public static void sendMessageToPlayer(EntityPlayer player, ITextComponent prefix, ITextComponent text, TextFormatting color, boolean shouldSendFromClient) {
        if (player.field_70170_p.field_72995_K == shouldSendFromClient) {
            player.func_145747_a(new TextComponentString("[").func_150257_a(prefix.func_150255_a(new Style().func_150238_a(color))).func_150257_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + "] ")).func_150257_a(text));
        }
    }

    public static void sendMessageEndingWithLink(ICommandSender sender, ITextComponent prefix, ITextComponent text, String link, TextFormatting color) {
        sender.func_145747_a(new TextComponentString("[").func_150257_a(prefix.func_150255_a(new Style().func_150238_a(color))).func_150257_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + "] ")).func_150257_a(text).func_150257_a((ITextComponent)new TextComponentString(": ")).func_150257_a(ForgeHooks.newChatWithLinks((String)link)));
    }

    public static boolean isHoldingItem(EntityPlayer player, Item item, EnumHand hand) {
        if (hand != EnumHand.OFF_HAND && !player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == item) {
            return true;
        }
        if (hand != EnumHand.MAIN_HAND && !player.func_184586_b(EnumHand.OFF_HAND).func_190926_b() && player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() == item) {
            return true;
        }
        return item == null;
    }

    public static ItemStack getSelectedItemStack(EntityPlayer player, Item item) {
        return PlayerUtils.getSelectedItemStack(player.field_71071_by, item);
    }

    public static ItemStack getSelectedItemStack(InventoryPlayer inventory, Item item) {
        if (!inventory.func_70448_g().func_190926_b() && inventory.func_70448_g().func_77973_b() == item) {
            return inventory.func_70448_g();
        }
        if (!((ItemStack)inventory.field_184439_c.get(0)).func_190926_b() && ((ItemStack)inventory.field_184439_c.get(0)).func_77973_b() == item) {
            return (ItemStack)inventory.field_184439_c.get(0);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isPlayerMountedOnCamera(EntityLivingBase entity) {
        return entity != null && entity.func_184187_bx() instanceof EntitySecurityCamera;
    }
}

