/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.ImmutablePair;
import worldcontrolteam.worldcontrol.blocks.BlockBasicRotate;
import worldcontrolteam.worldcontrol.blocks.BlockInfoPanel;
import worldcontrolteam.worldcontrol.client.ClientUtil;
import worldcontrolteam.worldcontrol.screen.IScreenContainer;
import worldcontrolteam.worldcontrol.tileentity.TileEntityInfoPanel;
import worldcontrolteam.worldcontrol.tileentity.TileEntityInfoPanelExtender;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class BlockInfoPanelExtender
extends BlockBasicRotate
implements IScreenContainer {
    private static ImmutableMap<EnumFacing, ImmutablePair<EnumFacing, EnumFacing>> facings;

    public BlockInfoPanelExtender(String name, boolean advanced) {
        super(Material.field_151573_f, name);
        this.defaultCreativeTab();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        WCUtility.getTileEntity((IBlockAccess)world, pos, TileEntityInfoPanelExtender.class).ifPresent(TileEntityInfoPanelExtender::init);
        for (EnumFacing f : EnumFacing.field_82609_l) {
            TileEntity te;
            BlockPos pos1;
            IBlockState b = world.func_180495_p(pos.func_177972_a(f));
            if (!(b.func_177230_c() instanceof IScreenContainer) || (pos1 = ((IScreenContainer)b.func_177230_c()).getOrigin((IBlockAccess)world, pos.func_177972_a(f))) == null || !((te = world.func_175625_s(pos1)) instanceof TileEntityInfoPanel) || world.field_72995_K) continue;
            ((TileEntityInfoPanel)te).tryToAdd(pos);
        }
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Optional<TileEntityInfoPanelExtender> optte = WCUtility.getTileEntity((IBlockAccess)world, pos, TileEntityInfoPanelExtender.class);
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
        optte.ifPresent(te_ -> {
            if (te_.origin != null) {
                WCUtility.getTileEntity((IBlockAccess)world, te_.origin, TileEntityInfoPanel.class).ifPresent(TileEntityInfoPanel::reInit);
            } else {
                for (EnumFacing f : EnumFacing.field_82609_l) {
                    TileEntity te;
                    BlockPos pos1;
                    IBlockState b = world.func_180495_p(pos.func_177972_a(f));
                    if (!(b.func_177230_c() instanceof IScreenContainer) || (pos1 = ((IScreenContainer)b.func_177230_c()).getOrigin((IBlockAccess)world, pos.func_177972_a(f))) == null || !((te = world.func_175625_s(pos1)) instanceof TileEntityInfoPanel)) continue;
                    if (!world.field_72995_K) {
                        ((TileEntityInfoPanel)te).reInit();
                    }
                    return;
                }
            }
        });
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).add(new IUnlistedProperty[]{BlockInfoPanel.STATE}).build();
    }

    @Override
    public TileEntity createTile(World world, int meta) {
        return new TileEntityInfoPanelExtender();
    }

    @Override
    public boolean hasGUI() {
        return false;
    }

    @Override
    public int guiID() {
        return 0;
    }

    @Override
    public EnumFacing getFacing(IBlockAccess worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return block == this ? (EnumFacing)worldIn.func_180495_p(pos).func_177228_b().get((Object)FACING) : EnumFacing.DOWN;
    }

    @Override
    public BlockPos getOrigin(IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityInfoPanelExtender) {
            return ((TileEntityInfoPanelExtender)tile).origin;
        }
        return null;
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        ClientUtil.registerToNormalWithoutMapper(this);
    }

    @Override
    public boolean isValid(World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        return tile instanceof TileEntityInfoPanelExtender;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState estate = (IExtendedBlockState)state;
            BlockInfoPanel.InfoPanelState istate = new BlockInfoPanel.InfoPanelState();
            istate.color = 10;
            istate.power = false;
            BlockPos origin = this.getOrigin(world, pos);
            if (origin != null) {
                TileEntity te_origin = world.func_175625_s(origin);
                if (te_origin instanceof TileEntityInfoPanel) {
                    istate.color = ((TileEntityInfoPanel)te_origin).color;
                    istate.power = ((TileEntityInfoPanel)te_origin).power;
                }
                EnumFacing f = this.getFacing(world, pos);
                istate.down = this.isConnectedTo(world, pos.func_177972_a((EnumFacing)((ImmutablePair)facings.get((Object)f)).getKey()), pos);
                istate.up = this.isConnectedTo(world, pos.func_177972_a(((EnumFacing)((ImmutablePair)facings.get((Object)f)).getKey()).func_176734_d()), pos);
                istate.left = this.isConnectedTo(world, pos.func_177972_a((EnumFacing)((ImmutablePair)facings.get((Object)f)).getValue()), pos);
                istate.right = this.isConnectedTo(world, pos.func_177972_a(((EnumFacing)((ImmutablePair)facings.get((Object)f)).getValue()).func_176734_d()), pos);
            }
            estate = estate.withProperty(BlockInfoPanel.STATE, (Object)istate);
            return estate;
        }
        return state;
    }

    private boolean isConnectedTo(IBlockAccess world, BlockPos offset, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityInfoPanelExtender) {
            TileEntityInfoPanelExtender tile1 = (TileEntityInfoPanelExtender)tile;
            if (tile1.origin == null) {
                return false;
            }
            Block block = world.func_180495_p(offset).func_177230_c();
            if (block instanceof IScreenContainer) {
                IScreenContainer cont = (IScreenContainer)block;
                return WCUtility.compareBPos(cont.getOrigin(world, offset), tile1.origin);
            }
            return false;
        }
        return false;
    }

    @Override
    public void setOrigin(World worldIn, BlockPos posBlock, BlockPos posOrigin) {
        TileEntity tile = worldIn.func_175625_s(posBlock);
        if (tile instanceof TileEntityInfoPanelExtender) {
            ((TileEntityInfoPanelExtender)tile).origin = posOrigin;
        }
        IBlockState bs = worldIn.func_180495_p(posBlock);
        worldIn.func_184138_a(posBlock, bs, bs, 2);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)EnumFacing.UP, (Object)new ImmutablePair((Object)EnumFacing.SOUTH, (Object)EnumFacing.WEST));
        builder.put((Object)EnumFacing.DOWN, (Object)new ImmutablePair((Object)EnumFacing.SOUTH, (Object)EnumFacing.EAST));
        builder.put((Object)EnumFacing.NORTH, (Object)new ImmutablePair((Object)EnumFacing.DOWN, (Object)EnumFacing.EAST));
        builder.put((Object)EnumFacing.SOUTH, (Object)new ImmutablePair((Object)EnumFacing.DOWN, (Object)EnumFacing.WEST));
        builder.put((Object)EnumFacing.EAST, (Object)new ImmutablePair((Object)EnumFacing.DOWN, (Object)EnumFacing.SOUTH));
        builder.put((Object)EnumFacing.WEST, (Object)new ImmutablePair((Object)EnumFacing.DOWN, (Object)EnumFacing.NORTH));
        facings = builder.build();
    }
}

