/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.crossmod.industrialcraft2.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import worldcontrolteam.worldcontrol.blocks.BlockBasicRotate;
import worldcontrolteam.worldcontrol.blocks.BlockIndustrialAlarm;
import worldcontrolteam.worldcontrol.crossmod.industrialcraft2.blocks.TileEntityIC2ReactorMonitor;
import worldcontrolteam.worldcontrol.tileentity.TileEntityBaseReactorHeatMonitor;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class BlockIC2ReactorMonitor
extends BlockIndustrialAlarm {
    public static PropertyEnum<RenderType> RENDER_TYPE = PropertyEnum.func_177709_a((String)"rendertype", RenderType.class);

    public BlockIC2ReactorMonitor() {
        super("ic2_reactor_monitor");
        this.func_180632_j(this.func_176223_P().func_177226_a(RENDER_TYPE, (Comparable)((Object)RenderType.NOT_FOUND)).func_177226_a((IProperty)BlockBasicRotate.FACING, (Comparable)EnumFacing.UP));
    }

    @Override
    public TileEntity createTile(World world, int meta) {
        return new TileEntityIC2ReactorMonitor();
    }

    @Override
    public boolean hasGUI() {
        return true;
    }

    @Override
    public int guiID() {
        return 4;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        if (facing == state.func_177229_b((IProperty)FACING)) {
            return 0;
        }
        return WCUtility.getTileEntity(world, pos, TileEntityIC2ReactorMonitor.class).map(t -> t.isOverHeated() ? 15 : 0).orElse(0);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, RENDER_TYPE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile;
        TileEntity tileEntity = tile = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (((TileEntityBaseReactorHeatMonitor)tile).isConnectionValid()) {
            return WCUtility.getTileEntity(world, pos, TileEntityIC2ReactorMonitor.class).map(t -> t.isOverHeated() ? state.func_177226_a(RENDER_TYPE, (Comparable)((Object)RenderType.OVER_HEAT)) : state.func_177226_a(RENDER_TYPE, (Comparable)((Object)RenderType.NORMAL))).orElse(state.func_177226_a(RENDER_TYPE, (Comparable)((Object)RenderType.NOT_FOUND)));
        }
        return state.func_177226_a(RENDER_TYPE, (Comparable)((Object)RenderType.NOT_FOUND));
    }

    public static enum RenderType implements IStringSerializable
    {
        NORMAL("ok"),
        NOT_FOUND("none"),
        OVER_HEAT("hot");

        private String name;

        private RenderType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

