/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.screen.img;

import com.google.common.collect.ImmutableSet;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import worldcontrolteam.worldcontrol.WorldControl;

public class ScreenImageMarshaller {
    public static ScreenImageMarshaller INSTANCE = new ScreenImageMarshaller();
    private static final ImmutableSet<String> validHosts = ImmutableSet.of((Object)"i.imgur.com", (Object)"i.redd.it");
    private static int maximumImages = 16;
    private int abs_max_size = 2048;
    private HashMap<String, ImageInfo> allocated_things = new HashMap();
    private HashMap<String, Float> last_partial_tick_usage = new HashMap();

    public ImageInfo tryGetImage(String imgURL, float currentTicks) {
        int h;
        ImageInfo i;
        if (WorldControl.PROXY.getImageGrabber() == null) {
            return null;
        }
        if (this.allocated_things.containsKey(imgURL) && this.allocated_things.get((Object)imgURL).texID >= 0) {
            this.last_partial_tick_usage.put(imgURL, Float.valueOf(currentTicks));
            return this.allocated_things.get(imgURL);
        }
        if (!this.allocated_things.containsKey(imgURL)) {
            i = new ImageInfo();
            i.texID = -1;
            i.imgKey = this.calculateKey(imgURL);
            WorldControl.PROXY.getImageGrabber().beginDownload(imgURL, i.imgKey);
            this.allocated_things.put(imgURL, i);
        }
        i = this.allocated_things.get(imgURL);
        BufferedImage possibleResult = WorldControl.PROXY.getImageGrabber().retrieveDownloadedImage(i.imgKey);
        if (possibleResult == null) {
            return null;
        }
        int w = possibleResult.getWidth();
        for (h = possibleResult.getHeight(); w > this.abs_max_size || h > this.abs_max_size; w /= 2, h /= 2) {
        }
        int minWTexSize = MathHelper.func_151236_b((int)w);
        int minHTexSize = MathHelper.func_151236_b((int)h);
        if (this.last_partial_tick_usage.size() > maximumImages) {
            this.removeSlotIfRequired();
        }
        i.texID = GlStateManager.func_179146_y();
        GlStateManager.func_179123_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179144_i((int)i.texID);
        Image finalImage = possibleResult.getScaledInstance(w, h, 2);
        BufferedImage im_format = new BufferedImage(minWTexSize, minHTexSize, 6);
        Graphics g = im_format.getGraphics();
        g.drawImage(finalImage, 0, 0, null);
        g.dispose();
        int[] data = new int[minWTexSize * minHTexSize];
        im_format.getRGB(0, 0, minWTexSize, minHTexSize, data, 0, minWTexSize);
        ByteBuffer b = BufferUtils.createByteBuffer((int)(minWTexSize * minHTexSize * 4));
        for (int y = 0; y < minHTexSize; ++y) {
            for (int x = 0; x < minWTexSize; ++x) {
                int pixel = data[y * minWTexSize + x];
                b.put((byte)(pixel >> 16 & 0xFF));
                b.put((byte)(pixel >> 8 & 0xFF));
                b.put((byte)(pixel & 0xFF));
                b.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        b.flip();
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)minWTexSize, (int)minHTexSize, (int)0, (int)6408, (int)5121, (ByteBuffer)b);
        if (GL11.glGetError() == 1285) {
            this.removeSlotIfRequired();
            GlStateManager.func_179144_i((int)0);
            GlStateManager.func_179150_h((int)i.texID);
            GlStateManager.func_179099_b();
            this.allocated_things.remove(imgURL);
            return null;
        }
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
        GlStateManager.func_179099_b();
        i.width = w;
        i.height = h;
        i.u = 1.0 / (double)minWTexSize * (double)w;
        i.v = 1.0 / (double)minHTexSize * (double)h;
        this.allocated_things.put(imgURL, i);
        this.last_partial_tick_usage.put(imgURL, Float.valueOf(currentTicks));
        return i;
    }

    private String calculateKey(String url) {
        try {
            URL u = new URL(url);
            return u.getHost() + "-" + u.getFile();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    private void removeSlotIfRequired() {
        String chosen = null;
        for (String url : this.allocated_things.keySet()) {
            if (this.allocated_things.get((Object)url).texID == -1 || !((double)this.last_partial_tick_usage.get(url).floatValue() > 800.0)) continue;
            chosen = url;
            break;
        }
        if (chosen != null) {
            GL11.glDeleteTextures((int)this.allocated_things.get(chosen).texID);
            this.allocated_things.remove(chosen);
            this.last_partial_tick_usage.remove(chosen);
        }
    }

    public boolean isImageURLValid(String imgURL) {
        URL url;
        try {
            url = new URL(imgURL);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return validHosts.contains((Object)url.getHost().toLowerCase().trim());
    }

    public void initGL() {
        this.abs_max_size = GlStateManager.func_187397_v((int)3379);
    }

    public static class ImageInfo {
        public int width;
        public int height;
        public double u;
        public double v;
        public int texID;
        public String imgKey;
    }
}

