/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.tileentity;

import com.google.common.collect.Lists;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import worldcontrolteam.worldcontrol.WorldControl;
import worldcontrolteam.worldcontrol.utils.RedstoneHelper;
import worldcontrolteam.worldcontrol.utils.WCConfig;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class TileEntityHowlerAlarm
extends TileEntity
implements ITickable,
RedstoneHelper.IRedstoneConsumer {
    private static final String DEFAULT_SOUND_NAME = "default";
    private static final String SOUND_PREFIX = "worldcontrol:alarm-";
    private static final float BASE_SOUND_RANGE = 16.0f;
    protected int tickRate = WCConfig.ticksBetweenHowlerSound;
    private String soundName = "default";
    private int color;
    private int range = WCConfig.alarmRange;
    private int updateTicker = 0;
    private boolean init = false;
    private boolean powered;
    @SideOnly(value=Side.CLIENT)
    private TileEntitySound sound;

    public TileEntityHowlerAlarm() {
        this.color = WCUtility.WHITE;
        if (WorldControl.SIDE == Side.CLIENT) {
            this.sound = new TileEntitySound(16.0f);
        }
    }

    @Override
    public boolean getPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean value) {
        this.powered = value;
        if (this.powered) {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                this.sound.playAlarm(this.func_174877_v().func_177963_a(0.5, 0.5, 0.5), SOUND_PREFIX + this.soundName, this.getNormalizedRange(), false);
            }
        } else if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.sound.stopAlarm();
        }
    }

    public void func_73660_a() {
        if (!this.init) {
            if (!this.func_145831_w().field_72995_K) {
                RedstoneHelper.checkPowered(this.func_145831_w(), this);
            }
            this.init = true;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (this.tickRate != -1 && this.updateTicker-- > 0) {
                return;
            }
            this.updateTicker = this.tickRate;
            this.checkStatus();
        }
    }

    protected void checkStatus() {
        RedstoneHelper.checkPowered(this.func_145831_w(), this);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && this.powered && !this.sound.isPlaying()) {
            this.sound.playAlarm(this.func_174877_v().func_177963_a(0.5, 0.5, 0.5), SOUND_PREFIX + this.soundName, this.getNormalizedRange(), true);
        }
    }

    private float getNormalizedRange() {
        if (this.func_145831_w().field_72995_K) {
            return (float)Math.min(this.range, WCConfig.SMPmaxAlarmRange) / 16.0f;
        }
        return (float)this.range / 16.0f;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        syncData.func_74778_a("soundName", this.soundName);
        syncData.func_74768_a("range", this.range);
        syncData.func_74768_a("color", this.color);
        syncData.func_74757_a("powered", this.powered);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, syncData);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.color = pkt.func_148857_g().func_74762_e("color");
        this.range = pkt.func_148857_g().func_74762_e("range");
        this.soundName = pkt.func_148857_g().func_74779_i("soundName");
        this.powered = pkt.func_148857_g().func_74767_n("powered");
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.color = nbttagcompound.func_74762_e("color");
        if (nbttagcompound.func_74764_b("soundName")) {
            this.soundName = nbttagcompound.func_74779_i("soundName");
            this.range = nbttagcompound.func_74762_e("range");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74778_a("soundName", this.soundName);
        nbttagcompound.func_74768_a("range", this.range);
        nbttagcompound.func_74768_a("color", this.color);
        return nbttagcompound;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public String getSound() {
        return this.soundName;
    }

    public void setSound(String sound) {
        this.soundName = Lists.newArrayList((Object[])WCConfig.howlerAlarmSounds).contains(sound) ? sound : DEFAULT_SOUND_NAME;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    @SideOnly(value=Side.CLIENT)
    public class TileEntitySound {
        private PositionedSoundRecord sound;
        private float DEFAULT_RANGE;

        public TileEntitySound(float ranger) {
            this.DEFAULT_RANGE = ranger;
        }

        public void stopAlarm() {
            if (this.sound != null) {
                Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.sound);
                this.sound = null;
            }
        }

        public void playAlarm(BlockPos pos, String soundName, float range, boolean skipCheck) {
            if (this.sound == null || skipCheck) {
                this.sound = this.playSound(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), soundName, range);
            }
        }

        public PositionedSoundRecord playSound(double x, double y, double z, String name, float volume) {
            Entity person;
            float range = this.DEFAULT_RANGE;
            if (volume > 1.0f) {
                range *= volume;
            }
            if ((person = FMLClientHandler.instance().getClient().func_175606_aa()) != null && volume > 0.0f && person.func_70092_e(x, y, z) < (double)(range * range)) {
                PositionedSoundRecord sound = new PositionedSoundRecord(new SoundEvent(new ResourceLocation(name)), SoundCategory.BLOCKS, volume, 1.0f, (float)x, (float)y, (float)z);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
                return sound;
            }
            return null;
        }

        public boolean isPlaying() {
            if (this.sound == null) {
                return false;
            }
            return Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)this.sound);
        }
    }
}

