/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseTileBlock;
import appeng.client.render.effects.LightningFX;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.tile.misc.TileQuartzGrowthAccelerator;
import appeng.util.Platform;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockQuartzGrowthAccelerator
extends AEBaseTileBlock
implements IOrientableBlock {
    private static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockQuartzGrowthAccelerator() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileQuartzGrowthAccelerator te = (TileQuartzGrowthAccelerator)this.getTileEntity(world, pos);
        boolean powered = te != null && te.isPowered();
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    @Override
    protected IProperty[] getAEStates() {
        return new IProperty[]{POWERED};
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World w, BlockPos pos, Random r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        TileQuartzGrowthAccelerator cga = (TileQuartzGrowthAccelerator)this.getTileEntity((IBlockAccess)w, pos);
        if (cga != null && cga.isPowered() && AppEng.proxy.shouldAddParticles(r)) {
            double d0 = r.nextFloat() - 0.5f;
            double d1 = r.nextFloat() - 0.5f;
            EnumFacing up = cga.getUp();
            EnumFacing forward = cga.getForward();
            EnumFacing west = Platform.crossProduct(forward, up);
            double rx = 0.5 + (double)pos.func_177958_n();
            double ry = 0.5 + (double)pos.func_177956_o();
            double rz = 0.5 + (double)pos.func_177952_p();
            rx += (double)up.func_82601_c() * d0;
            ry += (double)up.func_96559_d() * d0;
            rz += (double)up.func_82599_e() * d0;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            double dz = 0.0;
            double dx = 0.0;
            BlockPos pt = null;
            switch (r.nextInt(4)) {
                case 0: {
                    dx = 0.6;
                    dz = d1;
                    pt = new BlockPos(x + west.func_82601_c(), y + west.func_96559_d(), z + west.func_82599_e());
                    break;
                }
                case 1: {
                    dx = d1;
                    dz += 0.6;
                    pt = new BlockPos(x + forward.func_82601_c(), y + forward.func_96559_d(), z + forward.func_82599_e());
                    break;
                }
                case 2: {
                    dx = d1;
                    dz = -0.6;
                    pt = new BlockPos(x - forward.func_82601_c(), y - forward.func_96559_d(), z - forward.func_82599_e());
                    break;
                }
                case 3: {
                    dx = -0.6;
                    dz = d1;
                    pt = new BlockPos(x - west.func_82601_c(), y - west.func_96559_d(), z - west.func_82599_e());
                }
            }
            if (!w.func_180495_p(pt).func_177230_c().isAir(w.func_180495_p(pt), (IBlockAccess)w, pt)) {
                return;
            }
            rx += dx * (double)west.func_82601_c();
            ry += dx * (double)west.func_96559_d();
            rz += dx * (double)west.func_82599_e();
            LightningFX fx = new LightningFX(w, rx += dz * (double)forward.func_82601_c(), ry += dz * (double)forward.func_96559_d(), rz += dz * (double)forward.func_82599_e(), 0.0, 0.0, 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
        }
    }

    @Override
    public boolean usesMetadata() {
        return false;
    }
}

