/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui;

import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.common.util.NNList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;

public class ToolTipManager {
    @Nonnull
    private final Set<GuiToolTip> toolTips = Sets.newHashSet();

    public void addToolTip(@Nonnull GuiToolTip toolTip) {
        this.toolTips.add(toolTip);
    }

    public boolean removeToolTip(@Nonnull GuiToolTip toolTip) {
        return this.toolTips.remove(toolTip);
    }

    public void clearToolTips() {
        this.toolTips.clear();
    }

    protected final void drawTooltips(@Nonnull ToolTipRenderer renderer, int mouseX, int mouseY) {
        for (GuiToolTip toolTip : this.toolTips) {
            toolTip.onTick(mouseX - renderer.getGuiRootLeft(), mouseY - renderer.getGuiRootTop());
            if (!toolTip.shouldDraw()) continue;
            this.drawTooltip(toolTip, mouseX, mouseY, renderer);
        }
    }

    protected void drawTooltip(@Nonnull GuiToolTip toolTip, int mouseX, int mouseY, @Nonnull ToolTipRenderer renderer) {
        List<String> list = toolTip.getToolTipText();
        if (list.isEmpty()) {
            return;
        }
        NNList formatted = new NNList();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                formatted.add("\u00a7f" + list.get(i));
                continue;
            }
            formatted.add("\u00a77" + list.get(i));
        }
        renderer.drawHoveringToolTipText((List<String>)((Object)formatted), mouseX, mouseY, renderer.getFontRenderer());
    }

    public static interface ToolTipRenderer {
        public int getGuiRootLeft();

        public int getGuiRootTop();

        public int getGuiXSize();

        @Nonnull
        public FontRenderer getFontRenderer();

        public void drawHoveringToolTipText(@Nonnull List<String> var1, int var2, int var3, @Nonnull FontRenderer var4);
    }
}

