/*
 * Decompiled with CFR 0.152.
 */
package knugel.whoosh.gui;

import cofh.api.core.ISecurable;
import cofh.core.gui.container.ContainerCore;
import cofh.core.util.CoreUtils;
import cofh.core.util.helpers.SecurityHelper;
import com.mojang.authlib.GameProfile;
import java.util.List;
import knugel.whoosh.item.ItemTransporter;
import knugel.whoosh.network.PacketWhoosh;
import knugel.whoosh.util.TeleportPosition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ContainerTransporter
extends ContainerCore
implements ISecurable {
    ItemStack stack;

    public ContainerTransporter(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getContainerStack() {
        return this.stack;
    }

    public void appendPoint(TeleportPosition pos) {
        ItemTransporter.appendPoint(this.stack, pos);
        if (CoreUtils.isClient()) {
            PacketWhoosh.sendAddPosPacketToServer(pos);
        }
    }

    public void removePoint(int index) {
        ItemTransporter.removePoint(this.stack, index);
        if (CoreUtils.isClient()) {
            PacketWhoosh.sendRemovePosPacketToServer(index);
        }
    }

    public List<TeleportPosition> getPoints() {
        return ItemTransporter.getPositions(this.stack);
    }

    public int getSelected() {
        return ItemTransporter.getSelected(this.stack);
    }

    public void setSelected(int index) {
        ItemTransporter.setSelected(this.stack, index);
        if (CoreUtils.isClient()) {
            PacketWhoosh.sendSetSelectedPacketToServer(index);
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public boolean supportsShiftClick(int slotIndex) {
        return false;
    }

    protected int getPlayerInventoryVerticalOffset() {
        return 0;
    }

    protected int getSizeInventory() {
        return 0;
    }

    public boolean setAccess(ISecurable.AccessMode access) {
        if (SecurityHelper.setAccess((ItemStack)this.getContainerStack(), (ISecurable.AccessMode)access)) {
            if (CoreUtils.isClient()) {
                PacketWhoosh.sendSecurityPacketToServer(this);
            }
            return true;
        }
        return false;
    }

    public ISecurable.AccessMode getAccess() {
        return SecurityHelper.getAccess((ItemStack)this.getContainerStack());
    }

    public String getOwnerName() {
        return SecurityHelper.getOwnerName((ItemStack)this.getContainerStack());
    }

    public GameProfile getOwner() {
        return SecurityHelper.getOwner((ItemStack)this.getContainerStack());
    }

    public boolean canPlayerAccess(EntityPlayer player) {
        throw new UnsupportedOperationException();
    }

    public boolean setOwnerName(String name) {
        throw new UnsupportedOperationException();
    }

    public boolean setOwner(GameProfile name) {
        throw new UnsupportedOperationException();
    }
}

