/*
 * Decompiled with CFR 0.152.
 */
package knugel.whoosh.util;

import java.util.ArrayList;
import java.util.List;
import knugel.whoosh.item.ItemTransporter;
import knugel.whoosh.util.TeleportPosition;
import knugel.whoosh.util.WhooshTeleporter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TeleportUtil {
    private TeleportUtil() {
    }

    public static int getRFCost(World world, BlockPos pos, TeleportPosition target) {
        int cost = 0;
        if (world.field_73011_w.getDimension() != target.dimension) {
            cost += ItemTransporter.teleportDimensionCost;
        }
        cost = (int)((double)cost + Math.sqrt(pos.func_177951_i((Vec3i)target.position)) * (double)ItemTransporter.teleportBlockCost);
        return cost;
    }

    public static int getFluidCost(World world, TeleportPosition target) {
        int cost = 0;
        if (world.field_73011_w.getDimension() != target.dimension) {
            cost += ItemTransporter.teleportDimensionFluidCost;
        }
        return cost;
    }

    public static boolean performTeleport(World world, EntityPlayer player, TeleportPosition target) {
        BlockPos pos = target.position;
        if (world.field_73011_w.getDimension() != target.dimension) {
            TeleportUtil.teleportToDimension(player, target.dimension, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else {
            player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5);
        }
        return true;
    }

    public static int getRFCostBlink(World world, EntityPlayer player, int distance) {
        Vec3d eye = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d look = player.func_70040_Z();
        Vec3d end = eye.func_178787_e(new Vec3d(look.field_72450_a * (double)distance, look.field_72448_b * (double)distance, look.field_72449_c * (double)distance));
        RayTraceResult res = world.func_147447_a(eye, end, false, true, false);
        if (res == null) {
            return distance * ItemTransporter.teleportBlockBlinkCost;
        }
        Vec3d n = end.func_178788_d(res.field_72307_f).func_72432_b();
        ArrayList<BlockPos> empty = new ArrayList<BlockPos>();
        for (int d = distance - (int)Math.abs(eye.func_72438_d(res.field_72307_f)); d > 0; --d) {
            Vec3d v = res.field_72307_f.func_178787_e(n.func_186678_a((double)d));
            BlockPos dest = TeleportUtil.canFit(world, new BlockPos(v));
            if (dest == null) continue;
            empty.add(dest);
        }
        if (empty.size() != 0) {
            BlockPos dest = (BlockPos)empty.get(empty.size() / 2);
            return (int)Math.sqrt(dest.func_177951_i((Vec3i)new BlockPos(eye))) * ItemTransporter.teleportBlockBlinkCost;
        }
        return 0;
    }

    public static int getFluidCostBlink(World world, EntityPlayer player, int distance) {
        Vec3d eye = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d look = player.func_70040_Z();
        Vec3d end = eye.func_178787_e(new Vec3d(look.field_72450_a * (double)distance, look.field_72448_b * (double)distance, look.field_72449_c * (double)distance));
        RayTraceResult res = world.func_147447_a(eye, end, false, true, false);
        if (res == null) {
            return 0;
        }
        List<BlockPos> empty = TeleportUtil.getBlinkPositions(res, eye, end, distance, world);
        if (empty.size() == 0) {
            return 0;
        }
        BlockPos target = empty.get(empty.size() / 2);
        if (target != null) {
            if (TeleportUtil.isBlockBetween(world, eye, new Vec3d((double)target.func_177958_n() + 0.5, (double)target.func_177956_o(), (double)target.func_177952_p() + 0.5))) {
                return ItemTransporter.teleportFluidBlinkCost;
            }
            return 0;
        }
        return 0;
    }

    public static boolean performBlink(World world, EntityPlayer player, int distance) {
        Vec3d eye = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() - 0.08, player.field_70161_v);
        Vec3d look = player.func_70040_Z();
        Vec3d end = eye.func_178787_e(new Vec3d(look.field_72450_a * (double)distance, look.field_72448_b * (double)distance, look.field_72449_c * (double)distance));
        RayTraceResult res = world.func_147447_a(eye, end, false, true, false);
        if (res == null) {
            TeleportUtil.movePlayer(end, player, true);
            return true;
        }
        List<BlockPos> empty = TeleportUtil.getBlinkPositions(res, eye, end, distance, world);
        if (empty.size() == 0) {
            return false;
        }
        BlockPos target = empty.get(empty.size() / 2);
        if (target != null) {
            TeleportUtil.movePlayer(new Vec3d((double)target.func_177958_n() + 0.5, (double)target.func_177956_o(), (double)target.func_177952_p() + 0.5), player, false);
            return true;
        }
        return false;
    }

    private static List<BlockPos> getBlinkPositions(RayTraceResult ray, Vec3d eye, Vec3d end, int distance, World world) {
        Vec3d n = end.func_178788_d(ray.field_72307_f).func_72432_b();
        ArrayList<BlockPos> empty = new ArrayList<BlockPos>();
        for (int d = distance - (int)Math.abs(eye.func_72438_d(ray.field_72307_f)); d > 0; --d) {
            Vec3d v = ray.field_72307_f.func_178787_e(n.func_186678_a((double)d));
            BlockPos dest = TeleportUtil.canFit(world, new BlockPos(v));
            if (dest == null || dest.func_177956_o() <= 0) continue;
            empty.add(dest);
        }
        return empty;
    }

    private static void movePlayer(Vec3d destination, EntityPlayer player, boolean keepMomentum) {
        player.func_70634_a(destination.field_72450_a, destination.field_72448_b, destination.field_72449_c);
        if (keepMomentum) {
            Vec3d velocity = player.func_70040_Z();
            velocity = velocity.func_186678_a(0.25);
            SPacketEntityVelocity p = new SPacketEntityVelocity(player.func_145782_y(), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)p);
        }
        ((EntityPlayerMP)player).field_70143_R = 0.0f;
    }

    private static BlockPos canFit(World world, BlockPos pos) {
        if (world.func_175623_d(pos) && world.func_175623_d(pos.func_177972_a(EnumFacing.DOWN))) {
            return pos.func_177972_a(EnumFacing.DOWN);
        }
        if (world.func_175623_d(pos) && world.func_175623_d(pos.func_177972_a(EnumFacing.UP))) {
            return pos;
        }
        if (world.func_175623_d(pos.func_177972_a(EnumFacing.UP)) && world.func_175623_d(pos.func_177967_a(EnumFacing.UP, 2))) {
            return pos.func_177972_a(EnumFacing.UP);
        }
        return null;
    }

    private static boolean isBlockBetween(World world, Vec3d start, Vec3d target) {
        RayTraceResult res = world.func_72933_a(start, target);
        if (res == null) {
            return false;
        }
        return !res.func_178782_a().equals((Object)new BlockPos(target));
    }

    public static void teleportToDimension(EntityPlayer player, int dimension, double x, double y, double z) {
        int oldDimension = player.func_130014_f_().field_73011_w.getDimension();
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
        MinecraftServer server = player.func_130014_f_().func_73046_m();
        WorldServer worldServer = server.func_71218_a(dimension);
        player.func_82242_a(0);
        worldServer.func_73046_m().func_184103_al().transferPlayerToDimension(entityPlayerMP, dimension, (Teleporter)new WhooshTeleporter(worldServer, x, y, z));
        player.func_70634_a(x, y, z);
        if (oldDimension == 1) {
            player.func_70634_a(x, y, z);
            worldServer.func_72838_d((Entity)player);
            worldServer.func_72866_a((Entity)player, false);
        }
    }
}

