/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.api.inventory;

import com.tiviacz.travelersbackpack.common.InventoryRecipesRegistry;
import com.tiviacz.travelersbackpack.gui.container.slots.SlotFluid;
import com.tiviacz.travelersbackpack.gui.inventory.IInventoryTanks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public abstract class InventoryRecipe {
    private final ItemStack stackInRecipe;
    private final FluidStack fluidstackRecipe;
    private final int amountRecipe;
    private final ItemStack stackOutRecipe;
    private int recipeID;

    public InventoryRecipe(Item itemInRecipe, Fluid fluidRecipe, int amountRecipe, Item itemOutRecipe) {
        this(new ItemStack(itemInRecipe), fluidRecipe, amountRecipe, new ItemStack(itemOutRecipe));
    }

    public InventoryRecipe(Item itemInRecipe, FluidStack fluidstackRecipe, int amountRecipe, Item itemOutRecipe) {
        this(new ItemStack(itemInRecipe), fluidstackRecipe, amountRecipe, new ItemStack(itemOutRecipe));
    }

    public InventoryRecipe(ItemStack stackInRecipe, Fluid fluidRecipe, int amountRecipe, ItemStack stackOutRecipe) {
        this(stackInRecipe, new FluidStack(fluidRecipe, 1000), amountRecipe, stackOutRecipe);
    }

    public InventoryRecipe(ItemStack stackInRecipe, FluidStack fluidstackRecipe, int amountRecipe, ItemStack stackOutRecipe) {
        this.stackInRecipe = stackInRecipe;
        this.fluidstackRecipe = fluidstackRecipe;
        this.amountRecipe = amountRecipe;
        this.stackOutRecipe = stackOutRecipe;
        if (stackInRecipe != null && fluidstackRecipe != null && stackOutRecipe != null) {
            InventoryRecipesRegistry.registerRecipe(this);
        }
        this.addValidFluidItem();
    }

    public boolean canProcess(FluidTank tank, ItemStack stackOut) {
        ItemStack stackOutRecipe = this.stackOutRecipe.func_77946_l();
        if (this.amountRecipe > 0) {
            if (tank.getFluid() == null || tank.getFluid().isFluidEqual(this.fluidstackRecipe)) {
                if (stackOut.func_190926_b()) {
                    return true;
                }
                return stackOut.func_77969_a(stackOutRecipe) && stackOut.func_190916_E() + 1 <= stackOut.func_77976_d();
            }
        } else if (tank.getFluid() != null || tank.getFluidAmount() >= this.amountRecipe * -1) {
            if (stackOut.func_190926_b()) {
                return true;
            }
            return stackOut.func_77969_a(stackOutRecipe) && stackOut.func_190916_E() + 1 <= stackOut.func_77976_d();
        }
        return false;
    }

    public boolean processRecipe(EntityPlayer player, IInventoryTanks inv, FluidTank tank, int slotIn, int slotOut) {
        if (this.amountRecipe > 0) {
            if (tank.getFluidAmount() + this.amountRecipe <= tank.getCapacity()) {
                ItemStack stackOutRecipe = this.stackOutRecipe.func_77946_l();
                if (!inv.func_70301_a(slotOut).func_190926_b()) {
                    stackOutRecipe.func_190920_e(inv.func_70301_a(slotOut).func_190916_E() + 1);
                }
                tank.fill(new FluidStack(this.fluidstackRecipe, this.amountRecipe), true);
                inv.func_70299_a(slotOut, stackOutRecipe);
                inv.func_70298_a(slotIn, 1);
                inv.markTankDirty();
                if (player != null) {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, this.getSoundEventEmpty() == null ? SoundEvents.field_187697_dL : this.getSoundEventEmpty(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
        } else if (tank.getFluidAmount() - this.amountRecipe >= 0) {
            ItemStack stackOutRecipe = this.stackOutRecipe.func_77946_l();
            if (!inv.func_70301_a(slotOut).func_190926_b()) {
                stackOutRecipe.func_190920_e(inv.func_70301_a(slotOut).func_190916_E() + 1);
            }
            tank.drain(this.amountRecipe * -1, true);
            inv.func_70299_a(slotOut, stackOutRecipe);
            inv.func_70298_a(slotIn, 1);
            inv.markTankDirty();
            if (player != null) {
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, this.getSoundEventFill() == null ? SoundEvents.field_187697_dL : this.getSoundEventFill(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return false;
        }
        return false;
    }

    public ItemStack getStackIn() {
        return this.stackInRecipe;
    }

    public FluidStack getFluidStack() {
        return this.fluidstackRecipe;
    }

    public int getAmount() {
        return this.amountRecipe;
    }

    public ItemStack getStackOut() {
        return this.stackOutRecipe;
    }

    public boolean isRecipeNonNull() {
        return this.stackInRecipe != null && this.fluidstackRecipe != null && this.stackOutRecipe != null;
    }

    public void setRecipeID(int id) {
        this.recipeID = id;
    }

    public int getRecipeID() {
        return this.recipeID;
    }

    public void addValidFluidItem() {
        SlotFluid.validItems.add(this.getStackIn().func_77973_b());
    }

    public abstract SoundEvent getSoundEventFill();

    public abstract SoundEvent getSoundEventEmpty();
}

