/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.gui;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.gui.GuiImageButtonNormal;
import com.tiviacz.travelersbackpack.gui.GuiTank;
import com.tiviacz.travelersbackpack.gui.container.ContainerTravelersBackpack;
import com.tiviacz.travelersbackpack.gui.inventory.IInventoryTravelersBackpack;
import com.tiviacz.travelersbackpack.handlers.ConfigHandler;
import com.tiviacz.travelersbackpack.network.CycleToolPacket;
import com.tiviacz.travelersbackpack.network.EquipBackpackPacket;
import com.tiviacz.travelersbackpack.network.SleepingBagPacket;
import com.tiviacz.travelersbackpack.network.UnequipBackpackPacket;
import com.tiviacz.travelersbackpack.tileentity.TileEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.util.EnumSource;
import java.io.IOException;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTravelersBackpack
extends GuiContainer {
    public static final ResourceLocation GUI_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/travelers_backpack.png");
    private static final GuiImageButtonNormal bedButton = new GuiImageButtonNormal(5, 96, 18, 18);
    private static final GuiImageButtonNormal equipButton = new GuiImageButtonNormal(5, 96, 18, 18);
    private static final GuiImageButtonNormal unequipButton = new GuiImageButtonNormal(5, 96, 18, 18);
    private static final GuiImageButtonNormal emptyTankButtonLeft = new GuiImageButtonNormal(14, 86, 9, 9);
    private static final GuiImageButtonNormal emptyTankButtonRight = new GuiImageButtonNormal(225, 86, 9, 9);
    private static final GuiImageButtonNormal disabledCraftingButton = new GuiImageButtonNormal(225, 96, 18, 18);
    private TileEntityTravelersBackpack tile;
    private final InventoryPlayer playerInventory;
    private final IInventoryTravelersBackpack inventory;
    private boolean isWearing;
    private final GuiTank tankLeft;
    private final GuiTank tankRight;

    public GuiTravelersBackpack(World world, InventoryPlayer playerInventory, IInventoryTravelersBackpack inventory, boolean isWearing) {
        super((Container)new ContainerTravelersBackpack(world, playerInventory, inventory, isWearing ? EnumSource.WEARABLE : EnumSource.ITEM));
        this.playerInventory = playerInventory;
        this.inventory = inventory;
        this.isWearing = isWearing;
        this.tankLeft = new GuiTank(inventory.getLeftTank(), 25, 7, 100, 16);
        this.tankRight = new GuiTank(inventory.getRightTank(), 207, 7, 100, 16);
        this.field_146999_f = 248;
        this.field_147000_g = 207;
    }

    public GuiTravelersBackpack(World world, InventoryPlayer playerInventory, TileEntityTravelersBackpack tile) {
        super((Container)new ContainerTravelersBackpack(world, playerInventory, tile, EnumSource.TILE));
        this.playerInventory = playerInventory;
        this.inventory = tile;
        this.tile = tile;
        this.tankLeft = new GuiTank(this.inventory.getLeftTank(), 25, 7, 100, 16);
        this.tankRight = new GuiTank(this.inventory.getRightTank(), 207, 7, 100, 16);
        this.field_146999_f = 248;
        this.field_147000_g = 207;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.inventory.getLeftTank().getFluid() != null) {
            this.tankLeft.drawGuiFluidBar();
        }
        if (this.inventory.getRightTank().getFluid() != null) {
            this.tankRight.drawGuiFluidBar();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (this.tankLeft.inTank(this, mouseX, mouseY)) {
            this.drawHoveringText(this.tankLeft.getTankTooltip(), mouseX, mouseY, this.field_146289_q);
        }
        if (this.tankRight.inTank(this, mouseX, mouseY)) {
            this.drawHoveringText(this.tankRight.getTankTooltip(), mouseX, mouseY, this.field_146289_q);
        }
        if (this.isWearing && (emptyTankButtonLeft.inButton(this, mouseX, mouseY) || emptyTankButtonRight.inButton(this, mouseX, mouseY))) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.empty.name", (Object[])new Object[0]), mouseX, mouseY);
        }
        if (ConfigHandler.server.disableCrafting && disabledCraftingButton.inButton(this, mouseX, mouseY)) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.disabled_crafting.name", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TRAVELERS_BACKPACK);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (ConfigHandler.server.disableCrafting) {
            disabledCraftingButton.draw(this, 77, 208);
        }
        if (this.inventory.hasTileEntity()) {
            if (bedButton.inButton(this, mouseX, mouseY)) {
                bedButton.draw(this, 20, 227);
            } else {
                bedButton.draw(this, 1, 227);
            }
        }
        if (!this.inventory.hasTileEntity()) {
            if (!CapabilityUtils.isWearingBackpack(this.playerInventory.field_70458_d)) {
                if (equipButton.inButton(this, mouseX, mouseY)) {
                    equipButton.draw(this, 58, 208);
                } else {
                    equipButton.draw(this, 39, 208);
                }
            }
            if (CapabilityUtils.isWearingBackpack(this.playerInventory.field_70458_d) && this.isWearing) {
                if (unequipButton.inButton(this, mouseX, mouseY)) {
                    unequipButton.draw(this, 58, 227);
                } else {
                    unequipButton.draw(this, 39, 227);
                }
                if (ConfigHandler.server.enableEmptyTankButton) {
                    if (emptyTankButtonLeft.inButton(this, mouseX, mouseY)) {
                        emptyTankButtonLeft.draw(this, 29, 217);
                    } else {
                        emptyTankButtonLeft.draw(this, 10, 217);
                    }
                    if (emptyTankButtonRight.inButton(this, mouseX, mouseY)) {
                        emptyTankButtonRight.draw(this, 29, 217);
                    } else {
                        emptyTankButtonRight.draw(this, 10, 217);
                    }
                }
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (this.inventory.hasTileEntity() && bedButton.inButton(this, mouseX, mouseY)) {
            TravelersBackpack.NETWORK.sendToServer((IMessage)new SleepingBagPacket(this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p()));
        }
        if (!this.inventory.hasTileEntity() && !CapabilityUtils.isWearingBackpack(this.playerInventory.field_70458_d) && equipButton.inButton(this, mouseX, mouseY)) {
            TravelersBackpack.NETWORK.sendToServer((IMessage)new EquipBackpackPacket(true));
        }
        if (!this.inventory.hasTileEntity() && CapabilityUtils.isWearingBackpack(this.playerInventory.field_70458_d) && this.isWearing) {
            if (unequipButton.inButton(this, mouseX, mouseY)) {
                TravelersBackpack.NETWORK.sendToServer((IMessage)new UnequipBackpackPacket(true));
            }
            if (this.inventory.getLeftTank().getFluid() != null && emptyTankButtonLeft.inButton(this, mouseX, mouseY)) {
                TravelersBackpack.NETWORK.sendToServer((IMessage)new CycleToolPacket(1, 3));
            }
            if (this.inventory.getRightTank().getFluid() != null && emptyTankButtonRight.inButton(this, mouseX, mouseY)) {
                TravelersBackpack.NETWORK.sendToServer((IMessage)new CycleToolPacket(2, 3));
            }
        }
        super.func_73864_a(mouseX, mouseY, button);
    }
}

