/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.client;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.model.BakedCompositeModel;
import slimeknights.mantle.client.model.TRSRBakedModel;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.shared.block.PropertyTableItem;

public class BakedTableModel
extends BakedModelWrapper<IBakedModel> {
    static final Logger log = Util.getLogger("Table Model");
    private final IModel tableModel;
    private final Map<String, IBakedModel> cache = Maps.newHashMap();
    private static final Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> {
        assert (location != null);
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
    };
    private final VertexFormat format;
    private final LoadingCache<PropertyTableItem.TableItem, IBakedModel> tableItemCache = CacheBuilder.newBuilder().maximumSize(250L).build((CacheLoader)new CacheLoader<PropertyTableItem.TableItem, IBakedModel>(){

        public IBakedModel load(PropertyTableItem.TableItem key) throws Exception {
            return BakedTableModel.this.getModelForTableItem(key);
        }
    });
    private final Cache<TableItemCombinationCacheKey, IBakedModel> tableItemCombinedCache = CacheBuilder.newBuilder().maximumSize(20L).build();

    public BakedTableModel(IBakedModel standard, IModel tableModel, VertexFormat format) {
        super(standard);
        this.tableModel = tableModel;
        this.format = format;
    }

    protected IBakedModel getActualModel(String texture, List<PropertyTableItem.TableItem> items, EnumFacing facing) {
        IBakedModel bakedModel = this.originalModel;
        if (texture != null) {
            if (this.cache.containsKey(texture)) {
                bakedModel = this.cache.get(texture);
            } else if (this.tableModel != null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)"bottom", (Object)texture);
                builder.put((Object)"leg", (Object)texture);
                builder.put((Object)"legBottom", (Object)texture);
                IModel retexturedModel = this.tableModel.retexture(builder.build());
                IModelState modelState = retexturedModel.getDefaultState();
                bakedModel = retexturedModel.bake(modelState, this.format, textureGetter);
                this.cache.put(texture, bakedModel);
            }
        }
        IBakedModel parentModel = bakedModel;
        try {
            bakedModel = (IBakedModel)this.tableItemCombinedCache.get((Object)new TableItemCombinationCacheKey(items, bakedModel, facing), () -> this.getCombinedBakedModel(items, facing, parentModel));
        }
        catch (ExecutionException e) {
            log.error((Object)e);
        }
        return bakedModel;
    }

    private IBakedModel getCombinedBakedModel(List<PropertyTableItem.TableItem> items, EnumFacing facing, IBakedModel parentModel) {
        IBakedModel out = parentModel;
        if (items != null && !items.isEmpty()) {
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            if (Config.renderInventoryNullLayer) {
                ForgeHooksClient.setRenderLayer(null);
            }
            BakedCompositeModel.Builder builder = new BakedCompositeModel.Builder();
            builder.add(parentModel, null, 0L);
            for (PropertyTableItem.TableItem item : items) {
                try {
                    builder.add((IBakedModel)this.tableItemCache.get((Object)item), null, 0L);
                }
                catch (ExecutionException e) {
                    log.error((Object)e);
                }
            }
            out = builder.build(parentModel);
            if (Config.renderInventoryNullLayer) {
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            }
        }
        if (facing != null) {
            out = new TRSRBakedModel(out, facing);
        }
        return out;
    }

    private IBakedModel getModelForTableItem(PropertyTableItem.TableItem item) {
        return new TRSRBakedModel(item.model, item.x, item.y + 1.0f, item.z, item.r, (float)Math.PI, 0.0f, item.s);
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        String texture = null;
        List<PropertyTableItem.TableItem> items = Collections.emptyList();
        EnumFacing face = EnumFacing.SOUTH;
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            if (extendedState.getUnlistedNames().contains(BlockTable.TEXTURE)) {
                texture = (String)extendedState.getValue((IUnlistedProperty)BlockTable.TEXTURE);
            }
            if (Config.renderTableItems && extendedState.getUnlistedNames().contains(BlockTable.INVENTORY) && extendedState.getValue((IUnlistedProperty)BlockTable.INVENTORY) != null) {
                items = ((PropertyTableItem.TableItems)extendedState.getValue((IUnlistedProperty)BlockTable.INVENTORY)).items;
            }
            if (extendedState.getUnlistedNames().contains(BlockTable.FACING)) {
                face = (EnumFacing)extendedState.getValue((IUnlistedProperty)BlockTable.FACING);
            }
            state = extendedState.withProperty((IUnlistedProperty)BlockTable.INVENTORY, (Object)PropertyTableItem.TableItems.EMPTY).withProperty((IUnlistedProperty)BlockTable.FACING, null);
        }
        if (texture == null && items == null) {
            return this.originalModel.func_188616_a(state, side, rand);
        }
        return this.getActualModel(texture, items, face).func_188616_a(state, side, rand);
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return TableItemOverrideList.INSTANCE;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Pair pair = this.originalModel.handlePerspective(cameraTransformType);
        return Pair.of((Object)((Object)this), (Object)pair.getRight());
    }

    private static class TableItemCombinationCacheKey {
        private final List<PropertyTableItem.TableItem> tableItems;
        private final IBakedModel bakedBaseModel;
        private final EnumFacing facing;

        public TableItemCombinationCacheKey(List<PropertyTableItem.TableItem> tableItems, IBakedModel bakedBaseModel, EnumFacing facing) {
            this.tableItems = tableItems;
            this.bakedBaseModel = bakedBaseModel;
            this.facing = facing;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableItemCombinationCacheKey that = (TableItemCombinationCacheKey)o;
            if (this.tableItems != null ? !this.tableItems.equals(that.tableItems) : that.tableItems != null) {
                return false;
            }
            if (this.bakedBaseModel != null ? !this.bakedBaseModel.equals(that.bakedBaseModel) : that.bakedBaseModel != null) {
                return false;
            }
            return this.facing == that.facing;
        }

        public int hashCode() {
            int result = this.tableItems != null ? this.tableItems.hashCode() : 0;
            result = 31 * result + (this.bakedBaseModel != null ? this.bakedBaseModel.hashCode() : 0);
            result = 31 * result + (this.facing != null ? this.facing.hashCode() : 0);
            return result;
        }
    }

    private static class TableItemOverrideList
    extends ItemOverrideList {
        static TableItemOverrideList INSTANCE = new TableItemOverrideList();

        private TableItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            ItemStack blockStack;
            if (originalModel instanceof BakedTableModel && !(blockStack = new ItemStack(TagUtil.getTagSafe(stack).func_74775_l("textureBlock"))).func_190926_b()) {
                Block block = Block.func_149634_a((Item)blockStack.func_77973_b());
                String texture = ModelHelper.getTextureFromBlock((Block)block, (int)blockStack.func_77952_i()).func_94215_i();
                return ((BakedTableModel)originalModel).getActualModel(texture, Collections.emptyList(), null);
            }
            return originalModel;
        }
    }
}

