/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.inventory.ContainerMultiModule;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.tileentity.TileHeatingStructureFuelTank;

public class GuiHeatingStructureFuelTank
extends GuiMultiModule {
    protected TileHeatingStructureFuelTank.FuelInfo fuelInfo;

    public GuiHeatingStructureFuelTank(ContainerMultiModule<?> container) {
        super(container);
    }

    protected void drawFuel(int displayX, int displayY, int width, int height) {
        if (this.fuelInfo.fluid != null && this.fuelInfo.fluid.amount > 0) {
            int x = displayX + this.cornerX;
            int y = displayY + this.cornerY + height;
            int w = width;
            int h = height * this.fuelInfo.fluid.amount / this.fuelInfo.maxCap;
            GuiUtil.renderTiledFluid(x, y - h, w, h, this.field_73735_i, this.fuelInfo.fluid);
        }
    }

    protected void drawFuelTooltip(int mouseX, int mouseY) {
        ArrayList text = Lists.newArrayList();
        FluidStack fuel = this.fuelInfo.fluid;
        text.add(TextFormatting.WHITE + Util.translate("gui.smeltery.fuel", new Object[0]));
        if (fuel != null) {
            if (TinkerRegistry.isSmelteryFuel(fuel)) {
                text.add(fuel.getLocalizedName());
                GuiUtil.liquidToString(fuel, text);
                text.add(Util.translateFormatted("gui.smeltery.fuel.heat", Util.temperatureString(this.fuelInfo.heat)));
            } else {
                text.add(Util.translateFormatted("gui.smeltery.fuel.invalid", fuel.getLocalizedName()));
            }
        } else {
            text.add(Util.translate("gui.smeltery.fuel.empty", new Object[0]));
        }
        this.func_146283_a(text, mouseX, mouseY);
    }
}

