/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IToolMod;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTraits;

public class ModBlasting
extends ModifierTrait {
    public ModBlasting() {
        super("blasting", 16755235, 3, 0);
        ListIterator<ModifierAspect.FreeFirstModifierAspect> iter = this.aspects.listIterator();
        while (iter.hasNext()) {
            if (iter.next() != ModifierAspect.freeModifier) continue;
            iter.set(new ModifierAspect.FreeFirstModifierAspect(this, 1));
        }
        this.addAspects(ModifierAspect.harvestOnly);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean canApplyTogether(Enchantment enchantment) {
        return enchantment != Enchantments.field_185306_r && enchantment != Enchantments.field_185304_p && enchantment != Enchantments.field_185308_t;
    }

    @Override
    public boolean canApplyTogether(IToolMod toolmod) {
        String id = toolmod.getIdentifier();
        return !id.equals(TinkerModifiers.modLuck.getModifierIdentifier()) && !id.equals(TinkerModifiers.modSilktouch.getIdentifier()) && !id.equals(TinkerTraits.squeaky.getIdentifier()) && !id.equals(TinkerTraits.autosmelt.getIdentifier());
    }

    private int getLevel(ItemStack tool) {
        return ModifierNBT.readInteger((NBTTagCompound)TinkerUtil.getModifierTag((ItemStack)tool, (String)this.getModifierIdentifier())).level;
    }

    @Override
    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        World world = event.getEntityPlayer().func_130014_f_();
        float speed = ToolHelper.getActualMiningSpeed(tool);
        int level = this.getLevel(tool);
        float hardness = event.getState().func_185887_b(world, event.getPos());
        if (hardness <= 0.0f) {
            return;
        }
        speed *= hardness;
        speed = level > 2 ? (speed /= 1.1f) : (level > 1 ? (speed /= 5.0f) : (speed /= 10.0f));
        float weight1 = (float)level / (float)this.maxLevel;
        float weight2 = 1.0f - (float)level / (float)this.maxLevel;
        float totalSpeed = speed * weight1 + event.getOriginalSpeed() * weight2;
        event.setNewSpeed(totalSpeed);
    }

    private float getBlockDestroyChange(ItemStack tool) {
        float level = this.getLevel(tool);
        float chancePerLevel = 1.0f / (float)this.maxLevel;
        return level * chancePerLevel;
    }

    @Override
    public void afterBlockBreak(ItemStack tool, World world, IBlockState state, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
        EnumParticleTypes particleType = random.nextInt(20) == 0 ? EnumParticleTypes.EXPLOSION_LARGE : EnumParticleTypes.EXPLOSION_NORMAL;
        world.func_175688_a(particleType, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
    }

    @Override
    public void blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
        float chance = 1.0f - this.getBlockDestroyChange(tool);
        event.setDropChance(event.getDropChance() * chance);
    }

    @Override
    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getIdentifier());
        float chance = this.getBlockDestroyChange(tool);
        return ImmutableList.of((Object)Util.translateFormatted(loc, Util.dfPercent.format(chance)));
    }

    @Override
    public int getPriority() {
        return 200;
    }
}

