/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.handler.PlayerMorphHandler;
import me.ichun.mods.morph.common.morph.MorphInfo;
import me.ichun.mods.morph.common.morph.MorphState;
import me.ichun.mods.morph.common.morph.MorphVariant;
import me.ichun.mods.morph.common.packet.PacketDemorph;
import me.ichun.mods.morph.common.packet.PacketUpdateActiveMorphs;
import me.ichun.mods.morph.common.packet.PacketUpdateMorphList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EventHandlerServer {
    public HashMap<String, MorphInfo> morphsActive = new HashMap();
    public HashMap<String, ArrayList<MorphVariant>> playerMorphs = new HashMap();

    @SubscribeEvent
    public void onRegisterSound(RegistryEvent.Register<SoundEvent> event) {
        ResourceLocation rs = new ResourceLocation("morph", "morph");
        Morph.soundMorph = (SoundEvent)new SoundEvent(rs).setRegistryName(rs);
        event.getRegistry().register((IForgeRegistryEntry)Morph.soundMorph);
    }

    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent event) {
        EntityPlayer.SleepResult stats = EntityPlayer.SleepResult.OTHER_PROBLEM;
        if (Morph.config.canSleepMorphed == 0) {
            if (!event.getEntityPlayer().func_130014_f_().field_72995_K && Morph.eventHandlerServer.morphsActive.containsKey(event.getEntityPlayer().func_70005_c_())) {
                event.setResult(stats);
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("morph.denySleep", new Object[0]));
            } else if (event.getEntityPlayer().func_130014_f_().field_72995_K && Morph.eventHandlerClient.morphsActive.containsKey(event.getEntityPlayer().func_70005_c_())) {
                event.setResult(stats);
            }
        }
    }

    @SubscribeEvent
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            MorphInfo info;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            MorphInfo morphInfo = info = player.func_130014_f_().field_72995_K ? (MorphInfo)Morph.eventHandlerClient.morphsActive.get(player.func_70005_c_()) : Morph.eventHandlerServer.morphsActive.get(player.func_70005_c_());
            if (info != null && (SoundEvents.field_187800_eb.equals(event.getSound()) || SoundEvents.field_193805_fG.equals(event.getSound()) || SoundEvents.field_193806_fH.equals(event.getSound()) || SoundEvents.field_187798_ea.equals(event.getSound()))) {
                EntityLivingBase entInstance;
                EntityLivingBase entityLivingBase = entInstance = info.getMorphProgress(0.0f) < 0.5f ? info.prevState.getEntInstance(player.func_130014_f_()) : info.nextState.getEntInstance(player.func_130014_f_());
                event.setSound(SoundEvents.field_187798_ea.equals(event.getSound()) ? EntityHelper.getDeathSound((EntityLivingBase)entInstance, entInstance.getClass()) : EntityHelper.getHurtSound((EntityLivingBase)entInstance, entInstance.getClass(), (DamageSource)(SoundEvents.field_193806_fH.equals(event.getSound()) ? DamageSource.field_76370_b : (SoundEvents.field_193805_fG.equals(event.getSound()) ? DamageSource.field_76369_e : DamageSource.field_76377_j))));
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && (PlayerMorphHandler.getInstance().isEntityAMorph(event.getEntityLiving(), Side.SERVER) || event.getSource().func_76346_g() instanceof EntityLivingBase && PlayerMorphHandler.getInstance().isEntityAMorph((EntityLivingBase)event.getSource().func_76346_g(), Side.SERVER))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (!event.getEntityLiving().func_130014_f_().field_72995_K) {
            EntityPlayerMP player;
            if (Morph.config.loseMorphsOnDeath >= 1 && event.getEntityLiving() instanceof EntityPlayerMP) {
                player = (EntityPlayerMP)event.getEntityLiving();
                MorphInfo info = Morph.eventHandlerServer.morphsActive.get(player.func_70005_c_());
                if (info != null) {
                    MorphInfo newInfo = new MorphInfo((EntityPlayer)player, info.nextState, new MorphState(MorphVariant.createVariant((EntityLivingBase)player)));
                    newInfo.morphTime = 0;
                    Morph.eventHandlerServer.morphsActive.put(player.func_70005_c_(), newInfo);
                    Morph.channel.sendToAll((AbstractPacket)new PacketUpdateActiveMorphs(player.func_70005_c_()));
                    EntityHelper.playSoundAtEntity((Entity)player, (SoundEvent)Morph.soundMorph, (SoundCategory)player.func_184176_by(), (float)1.0f, (float)1.0f);
                }
                ArrayList<MorphVariant> morphs = Morph.eventHandlerServer.getPlayerMorphs((EntityPlayer)player);
                if (Morph.config.loseMorphsOnDeath == 1) {
                    morphs.clear();
                    this.playerMorphs.remove(player.func_70005_c_());
                    morphs = Morph.eventHandlerServer.getPlayerMorphs((EntityPlayer)player);
                } else {
                    morphs.remove(info.nextState.currentVariant);
                }
                Morph.channel.sendTo((AbstractPacket)new PacketUpdateMorphList(true, morphs.toArray(new MorphVariant[morphs.size()])), (EntityPlayer)player);
                PlayerMorphHandler.getInstance().savePlayerData((EntityPlayer)player);
            }
            if (event.getSource().func_76346_g() instanceof EntityPlayerMP && event.getEntityLiving() != event.getSource().func_76346_g()) {
                player = (EntityPlayerMP)event.getSource().func_76346_g();
                if (PlayerMorphHandler.getInstance().canPlayerMorph((EntityPlayer)player)) {
                    EntityPlayerMP player1;
                    MorphInfo info;
                    EntityLivingBase living = event.getEntityLiving();
                    if (event.getEntityLiving() instanceof EntityPlayerMP && (info = Morph.eventHandlerServer.morphsActive.get((player1 = (EntityPlayerMP)event.getEntityLiving()).func_70005_c_())) != null) {
                        living = info.isMorphing() && info.prevState != null ? info.prevState.getEntInstance(player1.func_130014_f_()) : info.nextState.getEntInstance(player1.func_130014_f_());
                    }
                    PlayerMorphHandler.getInstance().acquireMorph(player, living, Morph.config.instaMorph == 1, true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<Map.Entry<String, MorphInfo>> ite = Morph.eventHandlerServer.morphsActive.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, MorphInfo> e = ite.next();
                MorphInfo info = e.getValue();
                info.tick();
                if (info.isMorphing() || !info.nextState.currentVariant.playerName.equals(info.getPlayer().func_70005_c_())) continue;
                ite.remove();
                info.getPlayer().func_110148_a(SharedMonsterAttributes.field_111267_a).func_188479_b(MorphInfo.MORPH_HEALTH_ID);
                Morph.channel.sendToAll((AbstractPacket)new PacketDemorph(info.getPlayer().func_70005_c_()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        MorphInfo info;
        if (event.side.isServer() && event.player.func_130014_f_().field_73010_i.contains(event.player) && (info = this.morphsActive.get(event.player.func_70005_c_())) != null) {
            if (event.phase == TickEvent.Phase.START) {
                if (info.getPlayer() != event.player) {
                    info.setPlayer(event.player);
                }
                PlayerMorphHandler.setPlayerSize(event.player, info, true);
            } else {
                PlayerMorphHandler.setPlayerSize(event.player, info, true);
            }
        }
    }

    public ArrayList<MorphVariant> getPlayerMorphs(EntityPlayer player) {
        ArrayList<MorphVariant> morphs = this.playerMorphs.get(player.func_70005_c_());
        if (morphs == null) {
            morphs = new ArrayList();
            MorphVariant variant = new MorphVariant("PlayerMorph").setPlayer(player);
            variant.thisVariant.isFavourite = true;
            morphs.add(variant);
            this.playerMorphs.put(player.func_70005_c_(), morphs);
        }
        return morphs;
    }
}

