/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.handler;

import java.util.ArrayList;
import java.util.HashMap;
import me.ichun.mods.morph.api.ability.Ability;
import me.ichun.mods.morph.api.ability.AbilityApi;
import me.ichun.mods.morph.api.ability.IAbilityHandler;
import me.ichun.mods.morph.api.ability.type.AbilityClimb;
import me.ichun.mods.morph.api.ability.type.AbilityFallNegate;
import me.ichun.mods.morph.api.ability.type.AbilityFear;
import me.ichun.mods.morph.api.ability.type.AbilityFireImmunity;
import me.ichun.mods.morph.api.ability.type.AbilityFlightFlap;
import me.ichun.mods.morph.api.ability.type.AbilityFloat;
import me.ichun.mods.morph.api.ability.type.AbilityFly;
import me.ichun.mods.morph.api.ability.type.AbilityHostile;
import me.ichun.mods.morph.api.ability.type.AbilityPoisonResistance;
import me.ichun.mods.morph.api.ability.type.AbilityPotionEffect;
import me.ichun.mods.morph.api.ability.type.AbilitySink;
import me.ichun.mods.morph.api.ability.type.AbilityStep;
import me.ichun.mods.morph.api.ability.type.AbilitySunburn;
import me.ichun.mods.morph.api.ability.type.AbilitySwim;
import me.ichun.mods.morph.api.ability.type.AbilityWaterAllergy;
import me.ichun.mods.morph.api.ability.type.AbilityWitherResistance;
import me.ichun.mods.morph.common.Morph;
import net.minecraft.entity.EntityLivingBase;

public class AbilityHandler
implements IAbilityHandler {
    private static final AbilityHandler INSTANCE = new AbilityHandler();
    public static final HashMap<Class<? extends EntityLivingBase>, ArrayList<Ability>> ABILITY_MAP = new HashMap();
    public static final HashMap<String, Class<? extends Ability>> STRING_TO_CLASS_MAP = new HashMap();

    public static AbilityHandler getInstance() {
        return INSTANCE;
    }

    public static void init() {
        AbilityApi.setApiImpl(INSTANCE);
        AbilityApi.setApiImpl(INSTANCE);
        INSTANCE.registerAbility("climb", AbilityClimb.class);
        INSTANCE.registerAbility("fallNegate", AbilityFallNegate.class);
        INSTANCE.registerAbility("fear", AbilityFear.class);
        INSTANCE.registerAbility("fireImmunity", AbilityFireImmunity.class);
        INSTANCE.registerAbility("flightFlap", AbilityFlightFlap.class);
        INSTANCE.registerAbility("float", AbilityFloat.class);
        INSTANCE.registerAbility("fly", AbilityFly.class);
        INSTANCE.registerAbility("hostile", AbilityHostile.class);
        INSTANCE.registerAbility("poisonResistance", AbilityPoisonResistance.class);
        INSTANCE.registerAbility("potionEffect", AbilityPotionEffect.class);
        INSTANCE.registerAbility("sink", AbilitySink.class);
        INSTANCE.registerAbility("step", AbilityStep.class);
        INSTANCE.registerAbility("sunburn", AbilitySunburn.class);
        INSTANCE.registerAbility("swim", AbilitySwim.class);
        INSTANCE.registerAbility("waterAllergy", AbilityWaterAllergy.class);
        INSTANCE.registerAbility("witherResistance", AbilityWitherResistance.class);
    }

    @Override
    public void registerAbility(String name, Class<? extends Ability> clz) {
        STRING_TO_CLASS_MAP.put(name, clz);
    }

    @Override
    public void mapAbilities(Class<? extends EntityLivingBase> entClass, Ability ... abilities) {
        ArrayList abilityList = ABILITY_MAP.computeIfAbsent(entClass, k -> new ArrayList());
        for (Ability ability : abilities) {
            if (ability == null) continue;
            boolean added = false;
            if (!STRING_TO_CLASS_MAP.containsKey(ability.getType())) {
                this.registerAbility(ability.getType(), ability.getClass());
                Morph.LOGGER.warn((Object)("Ability type \"" + ability.getType() + "\" is not registered! Registering."));
            }
            for (int i = 0; i < abilityList.size(); ++i) {
                Ability ab = (Ability)abilityList.get(i);
                if (!ab.getType().equals(ability.getType())) continue;
                abilityList.remove(i);
                abilityList.add(i, ability);
                added = true;
            }
            if (added) continue;
            abilityList.add(ability);
        }
    }

    @Override
    public void removeAbility(Class<? extends EntityLivingBase> entClass, String type) {
        ArrayList<Ability> abilityList = ABILITY_MAP.get(entClass);
        if (abilityList != null) {
            for (int i = abilityList.size() - 1; i >= 0; --i) {
                Ability ability = abilityList.get(i);
                if (!ability.getType().equalsIgnoreCase(type)) continue;
                abilityList.remove(i);
            }
        }
    }

    @Override
    public boolean hasAbility(Class<? extends EntityLivingBase> entClass, String type) {
        return this.hasAbility(this.getEntityAbilities(entClass), type);
    }

    public boolean hasAbility(ArrayList<Ability> abilities, String type) {
        for (Ability ability : abilities) {
            if (!ability.getType().equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Ability createNewAbilityByType(String type, String json) {
        if (STRING_TO_CLASS_MAP.containsKey(type)) {
            try {
                return (Ability)AbilityApi.GSON.fromJson(json, STRING_TO_CLASS_MAP.get(type));
            }
            catch (Exception e) {
                Morph.LOGGER.warn((Object)("Error creating ability of type \"" + type + "\" with json: " + json));
                e.printStackTrace();
                return null;
            }
        }
        Morph.LOGGER.warn((Object)("Error creating ability of type \"" + type + "\". Such ability type is not registered."));
        return null;
    }

    @Override
    public ArrayList<Ability> getEntityAbilities(Class<? extends EntityLivingBase> entClass) {
        if (Morph.config.abilities == 1) {
            ArrayList<Ability> abilitiesDefault = ABILITY_MAP.get(entClass);
            if (abilitiesDefault == null) {
                Class<? extends EntityLivingBase> superClz = entClass.getSuperclass();
                if (superClz != EntityLivingBase.class) {
                    ABILITY_MAP.put(entClass, this.getEntityAbilities(superClz));
                    return this.getEntityAbilities(entClass);
                }
            } else {
                ArrayList<Ability> abilities = new ArrayList<Ability>();
                for (Ability ability : abilitiesDefault) {
                    abilities.add(ability.clone());
                }
                String[] disabledAbilities = Morph.config.disabledAbilities;
                block1: for (int i = abilities.size() - 1; i >= 0; --i) {
                    Ability ab = abilities.get(i);
                    for (String s : disabledAbilities) {
                        if (s.isEmpty() || !ab.getType().equals(s)) continue;
                        abilities.remove(i);
                        continue block1;
                    }
                }
                return abilities;
            }
        }
        return new ArrayList<Ability>();
    }
}

