/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive;

import icbm.classic.api.explosion.IExplosive;
import icbm.classic.client.models.ModelICBM;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.tile.EnumTier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Explosive
implements IExplosive {
    private String nameID;
    private EnumTier tier;
    private int fuseTime;
    protected boolean isDisabled;
    protected boolean hasBlock;
    protected boolean hasGrenade;
    protected boolean hasMissile;
    public float missileRenderScale = 1.0f;

    protected Explosive(String name, EnumTier tier) {
        this.nameID = name;
        this.tier = tier;
        this.fuseTime = 100;
        this.hasBlock = true;
        this.hasMissile = true;
        this.hasGrenade = this.tier.ordinal() <= EnumTier.ONE.ordinal();
        this.isDisabled = false;
    }

    @Override
    public String getTranslationKey() {
        return this.nameID;
    }

    @Override
    public String getExplosiveName() {
        return LanguageUtility.getLocal("icbm.explosive." + this.nameID + ".name");
    }

    @Override
    public String getGrenadeName() {
        return LanguageUtility.getLocal("icbm.grenade." + this.nameID + ".name");
    }

    @Override
    public String getMissileName() {
        return LanguageUtility.getLocal("icbm.missile." + this.nameID + ".name");
    }

    @Override
    public String getMinecartName() {
        return LanguageUtility.getLocal("icbm.minecart." + this.nameID + ".name");
    }

    @Override
    public EnumTier getTier() {
        return this.tier;
    }

    public Explosive setFuseTime(int fuse) {
        this.fuseTime = fuse;
        return this;
    }

    public int getFuseTimer() {
        return this.fuseTime;
    }

    public void onEntityCreated(World world, Entity entity) {
        world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void onFuseTick(World world, Pos position, int fuseTicks) {
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, position.x(), position.y() + 0.5, position.z(), 0.0, 0.0, 0.0, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelICBM getBlockModel() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getBlockResource() {
        return null;
    }

    public boolean hasGrenadeForm() {
        return this.hasGrenade;
    }

    public boolean hasMissileForm() {
        return this.hasMissile;
    }

    public boolean hasMinecartForm() {
        return this.hasBlockForm();
    }

    public boolean hasBlockForm() {
        return this.hasBlock;
    }

    public void init() {
    }

    public boolean onBlockActivated(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void createExplosion(World world, BlockPos pos, Entity entity, float scale) {
        if (!this.isDisabled) {
            this.doCreateExplosion(world, pos, entity, scale);
        }
    }

    public abstract void doCreateExplosion(World var1, BlockPos var2, Entity var3, float var4);
}

