/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.api.explosion.IExplosiveIgnore;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.ConfigBlast;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.entity.EntityExplosive;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.explosive.blast.Blast;
import icbm.classic.content.explosive.blast.threaded.BlastAntimatter;
import icbm.classic.content.missile.EntityMissile;
import icbm.classic.lib.transform.region.Cube;
import icbm.classic.lib.transform.rotation.EulerAngle;
import icbm.classic.lib.transform.vector.Location;
import icbm.classic.lib.transform.vector.Pos;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class BlastRedmatter
extends Blast {
    public static final float NORMAL_RADIUS = 70.0f;
    public static final float ENTITY_DESTROY_RADIUS = 6.0f;
    public static int MAX_BLOCKS_EDITS_PER_TICK = 100;
    public static int DEFAULT_BLOCK_EDITS_PER_TICK = 20;
    public static int MAX_LIFESPAN = 36000;
    public static float CHANCE_FOR_FLYING_BLOCK = 0.8f;
    public static boolean DO_DESPAWN = true;
    public static boolean doAudio = true;
    public static boolean doFlyingBlocks = true;
    public int lifeSpan = MAX_LIFESPAN;
    public int blocksEditsPerTick = -1;
    public boolean coloredBeams = true;

    public BlastRedmatter(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public float getScaleFactor() {
        return this.field_77280_f / 70.0f;
    }

    public int getBlocksPerTick() {
        if (this.blocksEditsPerTick == -1) {
            this.blocksEditsPerTick = (int)Math.min((float)MAX_BLOCKS_EDITS_PER_TICK, (float)DEFAULT_BLOCK_EDITS_PER_TICK * this.getScaleFactor());
        }
        return this.blocksEditsPerTick;
    }

    @Override
    public void doPreExplode() {
        if (!this.world().field_72995_K) {
            // empty if block
        }
    }

    @Override
    protected void doPostExplode() {
        AxisAlignedBB bounds = new AxisAlignedBB(this.field_77284_b - (double)this.field_77280_f, this.field_77285_c - (double)this.field_77280_f, this.field_77282_d - (double)this.field_77280_f, this.field_77284_b + (double)this.field_77280_f, this.field_77285_c + (double)this.field_77280_f, this.field_77282_d + (double)this.field_77280_f);
        List list = this.world().func_72872_a(EntityExplosion.class, bounds);
        for (Object obj : list) {
            EntityExplosion explosion;
            if (!(obj instanceof EntityExplosion) || (explosion = (EntityExplosion)((Object)obj)).getBlast() != this) continue;
            explosion.func_70106_y();
        }
    }

    @Override
    public void doExplode() {
        if (!this.world().field_72995_K) {
            if (DO_DESPAWN && this.callCount >= this.lifeSpan) {
                this.postExplode();
            }
            this.doDestroyBlocks();
            this.doEntityMovement();
            if (doAudio) {
                if (this.world().field_73012_v.nextInt(8) == 0) {
                    ICBMSounds.COLLAPSE.play(this.field_77287_j, this.location.x() + (Math.random() - 0.5) * (double)this.getBlastRadius(), this.location.y() + (Math.random() - 0.5) * (double)this.getBlastRadius(), this.location.z() + (Math.random() - 0.5) * (double)this.getBlastRadius(), 6.0f - this.world().field_73012_v.nextFloat(), 1.0f - this.world().field_73012_v.nextFloat() * 0.4f, true);
                }
                ICBMSounds.REDMATTER.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 3.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 1.0f, true);
            }
        }
    }

    protected void doDestroyBlocks() {
        long time = System.currentTimeMillis();
        int blocksDestroyed = 0;
        int currentRadius = 1;
        while ((float)currentRadius < this.getBlastRadius()) {
            for (int xr = -currentRadius; xr < currentRadius; ++xr) {
                for (int yr = -currentRadius; yr < currentRadius; ++yr) {
                    for (int zr = -currentRadius; zr < currentRadius; ++zr) {
                        IBlockState blockState;
                        Block block;
                        BlockPos blockPos = new BlockPos(this.location.xi() + xr, this.location.yi() + yr, this.location.zi() + zr);
                        double dist = this.location.distance((Vec3i)blockPos);
                        if (dist < (double)currentRadius && dist > (double)(currentRadius - 2) && (block = (blockState = this.field_77287_j.func_180495_p(blockPos)).func_177230_c()) != null) {
                            boolean isFluid;
                            boolean bl = isFluid = block instanceof BlockLiquid || block instanceof IFluidBlock;
                            if (!block.isAir(blockState, (IBlockAccess)this.world(), blockPos) && (isFluid && (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b) < 7 || !isFluid && blockState.func_185887_b(this.field_77287_j, blockPos) >= 0.0f)) {
                                this.field_77287_j.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), isFluid ? 2 : 3);
                                if (!isFluid && doFlyingBlocks && this.world().field_73012_v.nextFloat() > CHANCE_FOR_FLYING_BLOCK) {
                                    EntityFlyingBlock entity = new EntityFlyingBlock(this.world(), blockPos, blockState);
                                    entity.yawChange = 50.0f * this.world().field_73012_v.nextFloat();
                                    entity.pitchChange = 50.0f * this.world().field_73012_v.nextFloat();
                                    this.world().func_72838_d((Entity)entity);
                                    this.affectEntity(this.getBlastRadius() * 2.0f, entity, false);
                                }
                                ++blocksDestroyed;
                            }
                        }
                        if (blocksDestroyed <= this.getBlocksPerTick() && this.isAlive && System.currentTimeMillis() - time <= 30L) continue;
                        return;
                    }
                }
            }
            ++currentRadius;
        }
    }

    protected void doEntityMovement() {
        float entityRadius = this.getBlastRadius() * 2.0f;
        Cube cube = new Cube((IPos3D)((Object)((Location)this.location.add(0.5)).sub(entityRadius)), (IPos3D)((Object)((Location)this.location.add(0.5)).add(entityRadius)));
        AxisAlignedBB bounds = cube.getAABB();
        List allEntities = this.world().func_72872_a(Entity.class, bounds);
        boolean doExplosion = true;
        for (Entity entity : allEntities) {
            doExplosion = !this.affectEntity(entityRadius, entity, doExplosion);
        }
    }

    public boolean affectEntity(float radius, Entity entity, boolean doExplosion) {
        if (entity instanceof EntityPlayer && (((EntityPlayer)entity).field_71075_bZ.field_75098_d || ((EntityPlayer)entity).field_71075_bZ.field_75102_a)) {
            return false;
        }
        if (entity == this.controller) {
            return false;
        }
        if (entity instanceof IExplosiveIgnore && ((IExplosiveIgnore)entity).canIgnore(this)) {
            return false;
        }
        double xDifference = entity.field_70165_t - (double)this.location.xi() + 0.5;
        double yDifference = entity.field_70163_u - (double)this.location.yi() + 0.5;
        double zDifference = entity.field_70161_v - (double)this.location.zi() + 0.5;
        double xPercentage = 1.0 - xDifference / (double)radius;
        double yPercentage = 1.0 - yDifference / (double)radius;
        double zPercentage = 1.0 - zDifference / (double)radius;
        double distancePercentage = this.location.distance(entity) / (double)radius;
        Pos entityPosition = new Pos(entity);
        Pos centeredPosition = (Pos)entityPosition.subtract(this.location);
        centeredPosition = (Pos)centeredPosition.transform(new EulerAngle(1.5 * distancePercentage * Math.random(), 1.5 * distancePercentage * Math.random(), 1.5 * distancePercentage * Math.random()));
        Location newPosition = (Location)this.location.add(centeredPosition);
        entity.func_70024_g(newPosition.x() - entityPosition.x(), 0.0, newPosition.z() - entityPosition.z());
        entity.func_70024_g(-xDifference * 0.02 * xPercentage, -yDifference * 0.02 * yPercentage, -zDifference * 0.02 * zPercentage);
        if (entity instanceof EntityPlayer) {
            entity.field_70133_I = true;
        }
        boolean explosionCreated = false;
        Pos pos = new Pos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (pos.distance(this.location) < (double)(6.0f * this.getScaleFactor())) {
            if (entity instanceof EntityExplosion) {
                if (((EntityExplosion)entity).getBlast() instanceof BlastAntimatter) {
                    if (doAudio) {
                        ICBMSounds.EXPLOSION.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 7.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
                    }
                    if ((double)this.world().field_73012_v.nextFloat() > 0.85 && !this.world().field_72995_K) {
                        entity.func_70106_y();
                        return explosionCreated;
                    }
                } else if (((EntityExplosion)entity).getBlast() instanceof BlastRedmatter) {
                    double sizeA = this.getBlastRadius();
                    sizeA = sizeA * sizeA * sizeA;
                    double sizeB = ((EntityExplosion)entity).getBlast().getBlastRadius();
                    sizeB = sizeB * sizeB * sizeB;
                    float radiusNew = (float)Math.cbrt(sizeA + sizeB);
                    this.callCount = (this.callCount + ((EntityExplosion)entity).getBlast().callCount) / 2;
                    this.isAlive = false;
                    this.controller.func_70106_y();
                    new BlastRedmatter(this.world(), entity, this.location.x(), this.location.y(), this.location.z(), radiusNew).runBlast();
                }
                ((EntityExplosion)entity).getBlast().isAlive = false;
                entity.func_70106_y();
            } else if (entity instanceof EntityMissile) {
                ((EntityMissile)entity).doExplosion();
            } else if (entity instanceof EntityExplosive) {
                ((EntityExplosive)entity).explode();
            } else if (entity instanceof EntityLiving || entity instanceof EntityPlayer) {
                entity.func_70097_a((DamageSource)new DamageSourceRedmatter(this), 2000.0f);
            } else {
                entity.func_70106_y();
            }
        }
        return explosionCreated;
    }

    @Override
    public int proceduralInterval() {
        return 1;
    }

    @Override
    public boolean isMovable() {
        return ConfigBlast.REDMATTER_MOVEMENT;
    }

    public static class DamageSourceRedmatter
    extends DamageSource {
        public final BlastRedmatter blastRedmatter;

        public DamageSourceRedmatter(BlastRedmatter blastRedmatter) {
            super("icbm.redmatter");
            this.blastRedmatter = blastRedmatter;
        }
    }
}

