/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.handlers.missiles;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.config.ConfigMissile;
import icbm.classic.content.explosive.Explosives;
import icbm.classic.content.explosive.blast.BlastTNT;
import icbm.classic.content.explosive.handlers.missiles.Missile;
import icbm.classic.content.missile.EntityMissile;
import icbm.classic.content.missile.MissileFlightType;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.tile.EnumTier;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MissileCluster
extends Missile {
    protected double spread = 30.0;

    public MissileCluster(String name, EnumTier tier) {
        super(name, tier);
        this.hasBlock = false;
    }

    protected boolean shouldTrigger(EntityMissile missileCluster) {
        return missileCluster.field_70181_x < -0.5;
    }

    @Override
    public void update(EntityMissile missileCluster) {
        if (!missileCluster.isExploding() && this.shouldTrigger(missileCluster)) {
            missileCluster.isExploding = true;
            missileCluster.func_70106_y();
            for (int missileIndex = 0; missileIndex <= this.getMissileSpawnCount(); ++missileIndex) {
                if (missileCluster.field_70170_p.field_72995_K) continue;
                EntityMissile missile = this.createMissile(missileCluster, missileIndex);
                Pos position = (Pos)new Pos((IPos3D)missileCluster).add(this.getSpreadForMissile(missileIndex));
                missile.func_70107_b(position.x(), position.y(), position.z());
                missile.launcherPos = missileCluster.launcherPos;
                missile.missileType = MissileFlightType.DEAD_AIM;
                missile.protectionTime = 20 + missileCluster.targetHeight - 1;
                missile.ticksInAir = missileCluster.ticksInAir;
                if (missileCluster.targetPos != null) {
                    missile.launch((Pos)missileCluster.targetPos.add(this.getTargetDeltaForMissile(missileIndex)));
                } else {
                    Pos pos = (Pos)new Pos(missileCluster.field_70159_w, missileCluster.field_70181_x, missileCluster.field_70179_y).normalize();
                    pos = (Pos)pos.multiply(200.0);
                    pos = (Pos)pos.add(missileCluster);
                    pos = (Pos)pos.add(this.getTargetDeltaForMissile(missileIndex));
                    pos = (Pos)pos.addRandom(missileCluster.field_70170_p.field_73012_v, 4.0);
                    missile.launch(pos);
                }
                missileCluster.field_70170_p.func_72838_d((Entity)missile);
            }
        }
    }

    protected int getMissileSpawnCount() {
        return ConfigMissile.CLUSTER_SIZE;
    }

    protected EntityMissile createMissile(EntityMissile missileCluster, int index) {
        EntityMissile missile = new EntityMissile(missileCluster.field_70170_p);
        missile.explosiveID = Explosives.CONDENSED;
        return missile;
    }

    protected Pos getTargetDeltaForMissile(int index) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (index > 0) {
            double theta = this.getAngleForMissile(index);
            x = this.spread * Math.cos(theta);
            z = this.spread * Math.sin(theta);
        }
        return new Pos(x, y, z);
    }

    protected Pos getSpreadForMissile(int index) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (index > 0) {
            double theta = this.getAngleForMissile(index);
            x = Math.cos(theta) * this.getSpreadDistanceForMissile(index);
            z = Math.sin(theta) * this.getSpreadDistanceForMissile(index);
        }
        return new Pos(x, y, z);
    }

    protected double getSpreadDistanceForMissile(int index) {
        return index % 2 == 0 ? 4.0 : 7.0;
    }

    protected double getAngleForMissile(int index) {
        return (double)index / (double)this.getMissileSpawnCount() * Math.PI * 2.0;
    }

    @Override
    public void doCreateExplosion(World world, BlockPos pos, Entity entity, float scale) {
        new BlastTNT(world, entity, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 6.0f * scale).setDestroyItems().runBlast();
    }

    @Override
    public boolean isCruise() {
        return false;
    }
}

