/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.energy.system;

import icbm.classic.lib.energy.system.EnergySystemNull;
import icbm.classic.lib.energy.system.IEnergySystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public final class EnergySystem {
    private static final IEnergySystem NULL_SYSTEM = new EnergySystemNull();
    private static final List<IEnergySystem> energySystems = new ArrayList<IEnergySystem>();

    public static IEnergySystem getSystem(TileEntity tile, EnumFacing side) {
        return EnergySystem.getSystemForObject(tile, side);
    }

    public static IEnergySystem getSystem(Entity entity, EnumFacing side) {
        return EnergySystem.getSystemForObject(entity, side);
    }

    public static IEnergySystem getSystem(ItemStack item, EnumFacing side) {
        return EnergySystem.getSystemForObject(item, side);
    }

    private static IEnergySystem getSystemForObject(Object object, EnumFacing side) {
        for (IEnergySystem system : energySystems) {
            if (!system.canSupport(object, side)) continue;
            return system;
        }
        return NULL_SYSTEM;
    }

    public static void register(IEnergySystem energySystem) {
        if (energySystem != null) {
            energySystems.add(energySystem);
        }
    }
}

