/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.network.netty;

import icbm.classic.ICBMClassic;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.packet.PacketPlayerItem;
import icbm.classic.lib.network.packet.PacketTile;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraftforge.fml.common.network.FMLIndexedMessageToMessageCodec;

public class PacketEncoderDecoderHandler
extends FMLIndexedMessageToMessageCodec<IPacket> {
    public boolean silenceStackTrace = false;
    private int nextID = 0;

    public PacketEncoderDecoderHandler() {
        this.addPacket(PacketTile.class);
        this.addPacket(PacketPlayerItem.class);
    }

    public void addPacket(Class<? extends IPacket> clazz) {
        this.addDiscriminator(this.nextID++, clazz);
    }

    public void encodeInto(ChannelHandlerContext ctx, IPacket packet, ByteBuf target) throws Exception {
        try {
            packet.encodeInto(ctx, target);
        }
        catch (Exception e) {
            if (!this.silenceStackTrace) {
                ICBMClassic.logger().error("Failed to encode packet " + packet, (Throwable)e);
            }
            ICBMClassic.logger().error("Failed to encode packet " + packet + " E: " + e.getMessage());
        }
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, IPacket packet) {
        try {
            packet.decodeInto(ctx, source);
        }
        catch (Exception e) {
            if (!this.silenceStackTrace) {
                ICBMClassic.logger().error("Failed to decode packet " + packet, (Throwable)e);
            }
            ICBMClassic.logger().error("Failed to decode packet " + packet + " E: " + e.getMessage());
        }
    }
}

