/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab.item;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class ItemStackCapProvider
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound> {
    public final ItemStack host;
    public HashMap<Capability, Object> capTypeToCap = new HashMap();
    public HashMap<String, Object> keyToCap = new HashMap();

    public ItemStackCapProvider(ItemStack host) {
        this.host = host;
    }

    public <T> void add(String key, Capability<T> capability, T cap) {
        this.capTypeToCap.put(capability, cap);
        this.keyToCap.put(key, cap);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.capTypeToCap.containsKey(capability);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.capTypeToCap.containsKey(capability)) {
            return (T)this.capTypeToCap.get(capability);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        for (Map.Entry<String, Object> entry : this.keyToCap.entrySet()) {
            if (!(entry.getValue() instanceof INBTSerializable)) continue;
            tag.func_74782_a(entry.getKey(), ((INBTSerializable)entry.getValue()).serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        for (Map.Entry<String, Object> entry : this.keyToCap.entrySet()) {
            if (!(entry.getValue() instanceof INBTSerializable)) continue;
            ((INBTSerializable)entry.getValue()).deserializeNBT(nbt.func_74781_a(entry.getKey()));
        }
    }
}

