/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer.config;

import bre.fpsreducer.config.CommonConfig;
import java.io.File;
import net.minecraftforge.common.config.Property;

public class GlobalConfig
extends CommonConfig {
    public boolean debugLog;
    public boolean logInChat;
    public int hudColorRed;
    public int hudColorGreen;
    public int hudColorBlue;
    public String hudPreText = "FPS: ";
    public int hudReductionColorRed;
    public int hudReductionColorGreen;
    public int hudReductionColorBlue;
    public String hudReductionPreText = "ECO: ";
    public boolean enablePerPlayerConfig;
    public int cpuUsageType;
    public static final int CPU_USAGE_TYPE_ONE_CPU_BASIS = 0;
    public static final int CPU_USAGE_TYPE_ALL_CPU_BASIS = 1;
    public int cpuUsageThread;
    public static final int CPU_USAGE_THREAD_CLIENT_ONLY = 0;
    public static final int CPU_USAGE_THREAD_ALL = 1;
    private Property debugLogProp;
    private Property logInChatProp;
    private Property hudColorRedProp;
    private Property hudColorGreenProp;
    private Property hudColorBlueProp;
    private Property hudReductionColorRedProp;
    private Property hudReductionColorGreenProp;
    private Property hudReductionColorBlueProp;
    private Property enablePerPlayerConfigProp;
    private Property cpuUsageTypeProp;
    private Property cpuUsageThreadProp;

    public GlobalConfig(File configFile) {
        super(configFile);
    }

    @Override
    public void loadConfig() {
        super.loadConfig();
        this.debugLogProp = this.cfg.get("debug", "debugLog", false, "Enable debug log.");
        this.logInChatProp = this.cfg.get("debug", "showLogInChat", false, "Show event log on the game screen.");
        this.hudColorRedProp = this.cfg.get("global", "hudColorRed", 240, "HUD color red (0-255)", 0, 255);
        this.hudColorGreenProp = this.cfg.get("global", "hudColorGreen", 240, "HUD color green (0-255)", 0, 255);
        this.hudColorBlueProp = this.cfg.get("global", "hudColorBlue", 240, "HUD color blue (0-255)", 0, 255);
        this.hudReductionColorRedProp = this.cfg.get("global", "hudReductionColorRed", 0, "Reduced fps HUD color red (0-255)", 0, 255);
        this.hudReductionColorGreenProp = this.cfg.get("global", "hudReductionColorGreen", 255, "Reduced fps HUD color green (0-255)", 0, 255);
        this.hudReductionColorBlueProp = this.cfg.get("global", "hudReductionColorBlue", 0, "Reduced fps HUD color blue (0-255)", 0, 255);
        this.enablePerPlayerConfigProp = this.cfg.get("global", "enablePerPlayerConfig", true, "Enable per-player configuration.");
        this.cpuUsageTypeProp = this.cfg.get("global", "cpuUsageType", 0, "CPU usage type. (0:one processor basis, 1:all processors basis)");
        this.cpuUsageThreadProp = this.cfg.get("global", "cpuUsageThread", 0, "Which thread's CPU usage should be calculated. (0:client thread only, 1:entire Minecraft process including server threads)");
        this.readValuesFromProp();
    }

    private void readValuesFromProp() {
        this.debugLog = this.debugLogProp.getBoolean();
        this.logInChat = this.logInChatProp.getBoolean();
        this.hudColorRed = this.hudColorRedProp.getInt();
        this.hudColorGreen = this.hudColorGreenProp.getInt();
        this.hudColorBlue = this.hudColorBlueProp.getInt();
        this.hudReductionColorRed = this.hudReductionColorRedProp.getInt();
        this.hudReductionColorGreen = this.hudReductionColorGreenProp.getInt();
        this.hudReductionColorBlue = this.hudReductionColorBlueProp.getInt();
        this.enablePerPlayerConfig = this.enablePerPlayerConfigProp.getBoolean();
        this.cpuUsageType = this.cpuUsageTypeProp.getInt();
        this.cpuUsageThread = this.cpuUsageThreadProp.getInt();
    }

    @Override
    public void saveConfig() {
        this.debugLogProp.setValue(this.debugLog);
        this.logInChatProp.setValue(this.logInChat);
        this.hudColorRedProp.setValue(this.hudColorRed);
        this.hudColorGreenProp.setValue(this.hudColorGreen);
        this.hudColorBlueProp.setValue(this.hudColorBlue);
        this.hudReductionColorRedProp.setValue(this.hudReductionColorRed);
        this.hudReductionColorGreenProp.setValue(this.hudReductionColorGreen);
        this.hudReductionColorBlueProp.setValue(this.hudReductionColorBlue);
        this.enablePerPlayerConfigProp.setValue(this.enablePerPlayerConfig);
        this.cpuUsageTypeProp.setValue(this.cpuUsageType);
        this.cpuUsageThreadProp.setValue(this.cpuUsageThread);
        super.saveConfig();
    }

    @Override
    protected void convertVersion() {
        super.convertVersion();
        if (this.cfg.getLoadedConfigVersion() == null && this.hudColorRed == 192 && this.hudColorGreen == 192 && this.hudColorBlue == 192) {
            this.hudColorRed = 240;
            this.hudColorGreen = 240;
            this.hudColorBlue = 240;
        }
        this.removeKey("settings", "enableHUD");
        if (this.getLoadedConfigVersionInt() < 4) {
            int hudRefPos = this.cfg.get("global", "hudLocation", 2).getInt() * 2 - 1;
            if (hudRefPos <= 0) {
                hudRefPos = 1;
                this.hudInfo = 0;
            }
            this.setHudReferencePos(hudRefPos);
            this.removeKey("global", "hudLocation");
            this.hudScale = this.cfg.get("global", "hudScale", this.hudScaleDefault).getDouble();
            this.removeKey("global", "hudScale");
            this.hudBehindChatBox = this.cfg.get("global", "hudBehindChatBox", this.hudBehindChatBoxDefault).getInt();
            this.removeKey("global", "hudBehindChatBox");
            this.removeKey("global", "hudMarginX");
            this.removeKey("global", "hudMarginY");
            this.removeKey("global", "hudPreText");
            this.removeKey("global", "hudReductionPreText");
        }
    }
}

