/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer.config;

import bre.fpsreducer.utils.Logger;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class OldConfig {
    private static Configuration cfg;
    private static final String configVersion = "2";
    public static boolean debugLog;
    public static boolean chatMsg;
    public static int waitingTime;
    public static int idleFPS;
    public static int hudLocation;
    public static boolean enableFpsReducer;
    public static boolean ignoreHoldButton;
    public static boolean reducingInBackground;
    public static boolean suppressSound;
    public static int suppressedVolume;
    public static int hudMarginX;
    public static int hudMarginY;
    public static int hudColorRed;
    public static int hudColorGreen;
    public static int hudColorBlue;
    private static Property debugLogProperty;
    private static Property chatMsgProperty;
    private static Property enableFpsReducerProperty;
    private static Property waitingTimeProperty;
    private static Property idleFpsProperty;
    private static Property hudLocationProperty;
    private static Property ignoreHoldButtonProperty;
    private static Property reducingInBackgroundProperty;
    private static Property suppressSoundProperty;
    private static Property suppressedVolumeProperty;
    private static Property hudMarginXProperty;
    private static Property hudMarginYProperty;
    private static Property hudColorRedProperty;
    private static Property hudColorGreenProperty;
    private static Property hudColorBlueProperty;

    public static void readConfig(File configFile) {
        cfg = new Configuration(configFile, configVersion);
        try {
            OldConfig.loadConfig();
            waitingTime = waitingTimeProperty.getInt();
            idleFPS = idleFpsProperty.getInt();
            enableFpsReducer = enableFpsReducerProperty.getBoolean();
            hudLocation = hudLocationProperty.getInt();
            debugLog = debugLogProperty.getBoolean();
            chatMsg = chatMsgProperty.getBoolean();
            ignoreHoldButton = ignoreHoldButtonProperty.getBoolean();
            reducingInBackground = reducingInBackgroundProperty.getBoolean();
            suppressSound = suppressSoundProperty.getBoolean();
            suppressedVolume = suppressedVolumeProperty.getInt();
            hudMarginX = hudMarginXProperty.getInt();
            hudMarginY = hudMarginYProperty.getInt();
            hudColorRed = hudColorRedProperty.getInt();
            hudColorGreen = hudColorGreenProperty.getInt();
            hudColorBlue = hudColorBlueProperty.getInt();
        }
        catch (Exception e) {
            Logger.error("FpsReducer config file access error.");
        }
        finally {
            OldConfig.convertVersion();
        }
    }

    private static void loadConfig() {
        cfg.load();
        waitingTimeProperty = cfg.get("settings", "waitingTime", 300, "Waiting time(sec) until reducing FPS.", 0, 86400);
        idleFpsProperty = cfg.get("settings", "idleFPS", 10, "Frame rate during reducing.", 1, 260);
        enableFpsReducerProperty = cfg.get("settings", "enableFpsReducer", true, "Enable reducing FPS when no user activity has been sensed for a certain time.");
        hudLocationProperty = cfg.get("settings", "hudLocation", 2, "Display the status and the current FPS at the specified location.\n(0:off, 1:top-left, 2:top-right, 3:bottom-right, 4:bottom-left)");
        debugLogProperty = cfg.get("debug", "DebugLog", false, "Enable debug log.");
        chatMsgProperty = cfg.get("debug", "ShowLogInChat", false, "Show event log on the game screen.");
        ignoreHoldButtonProperty = cfg.get("settings", "ignoreHoldButton", false, "Ignore the mouse button holding.");
        reducingInBackgroundProperty = cfg.get("settings", "reducingInBackground", false, "Force reducing FPS if the window is inactive.");
        suppressSoundProperty = cfg.get("settings", "suppressSound", false, "Suppress master volume if the window is inactive.");
        suppressedVolumeProperty = cfg.get("settings", "suppressedVolume", 10, "Suppression master volume ratio in inactive (0-100).", 0, 100);
        hudMarginXProperty = cfg.get("settings", "hudMarginX", 2, "X margin of HUD position from screen edge.");
        hudMarginYProperty = cfg.get("settings", "hudMarginY", 2, "Y margin of HUD position from screen edge.");
        hudColorRedProperty = cfg.get("settings", "hudColorRed", 240, "HUD color red (0-255)", 0, 255);
        hudColorGreenProperty = cfg.get("settings", "hudColorGreen", 240, "HUD color green (0-255)", 0, 255);
        hudColorBlueProperty = cfg.get("settings", "hudColorBlue", 240, "HUD color blue (0-255)", 0, 255);
    }

    private static void convertVersion() {
        if (cfg.getLoadedConfigVersion() == null) {
            if (hudMarginX == 1 && hudMarginY == 1) {
                hudMarginX = 2;
                hudMarginY = 2;
            }
            if (hudColorRed == 192 && hudColorGreen == 192 && hudColorBlue == 192) {
                hudColorRed = 240;
                hudColorGreen = 240;
                hudColorBlue = 240;
            }
        }
    }
}

