/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.mjrlegendslib.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.mjr.mjrlegendslib.client.model.OBJLoaderCustom;
import com.mjr.mjrlegendslib.util.MCUtilities;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelUtilities {
    public static void drawBakedModel(IBakedModel model) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad bakedquad : model.func_188616_a(null, null, 0L)) {
            worldrenderer.func_178981_a(bakedquad.func_178209_a());
        }
        tessellator.func_78381_a();
    }

    public static void drawBakedModelColored(IBakedModel model, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad bakedquad : model.func_188616_a(null, null, 0L)) {
            int[] data = bakedquad.func_178209_a();
            data[3] = color;
            data[10] = color;
            data[17] = color;
            data[24] = color;
            worldrenderer.func_178981_a(data);
        }
        tessellator.func_78381_a();
    }

    public static IBakedModel modelFromOBJForge(ResourceLocation loc) throws Exception {
        return ModelUtilities.modelFromOBJForge(loc, (List<String>)ImmutableList.of((Object)"main"));
    }

    public static IBakedModel modelFromOBJForge(ResourceLocation loc, List<String> visibleGroups) throws Exception {
        return ModelUtilities.modelFromOBJForge(loc, visibleGroups, (IModelState)TRSRTransformation.identity());
    }

    public static IBakedModel modelFromOBJForge(ResourceLocation loc, List<String> visibleGroups, IModelState parentState) throws Exception {
        OBJModel model = (OBJModel)ModelLoaderRegistry.getModel((ResourceLocation)loc);
        Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        return model.bake((IModelState)new OBJModel.OBJState(visibleGroups, false, parentState), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
    }

    public static IBakedModel modelFromOBJ(ResourceLocation loc) throws IOException {
        return ModelUtilities.modelFromOBJ(loc, (List<String>)ImmutableList.of((Object)"main"));
    }

    public static IBakedModel modelFromOBJ(ResourceLocation loc, List<String> visibleGroups) throws IOException {
        return ModelUtilities.modelFromOBJ(loc, visibleGroups, (IModelState)TRSRTransformation.identity());
    }

    public static IBakedModel modelFromOBJ(ResourceLocation loc, List<String> visibleGroups, IModelState parentState) throws IOException {
        IModel model = OBJLoaderCustom.instance.loadModel(loc);
        Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        return model.bake((IModelState)new OBJModel.OBJState(visibleGroups, false, parentState), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
    }

    public static IBakedModel getModelFromRegistry(ModelResourceLocation modelResourceLocation) {
        return MCUtilities.getClient().func_175599_af().func_175037_a().func_178083_a().func_174953_a(modelResourceLocation);
    }

    public static IBakedModel getModelFromRegistry(String texturePrefix, String name) {
        return MCUtilities.getClient().func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation(texturePrefix + name, "inventory"));
    }
}

