/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.ContainerAirCannon;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAirCannon;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class GuiAirCannon
extends GuiPneumaticContainerBase<TileEntityAirCannon> {
    private GuiAnimatedStat statusStat;
    private GuiAnimatedStat strengthTab;
    private int gpsX;
    private int gpsY;
    private int gpsZ;

    public GuiAirCannon(InventoryPlayer player, TileEntityAirCannon te) {
        super(new ContainerAirCannon(player, te), te, "pneumaticcraft:textures/gui/gui_air_cannon.png");
        this.gpsX = te.gpsX;
        this.gpsY = te.gpsY;
        this.gpsZ = te.gpsZ;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.statusStat = this.addAnimatedStat("Cannon Status", new ItemStack(Blockss.AIR_CANNON), -22016, false);
        this.strengthTab = this.addAnimatedStat("Force", new ItemStack(Itemss.AIR_CANISTER), -14647041, false);
        this.strengthTab.addPadding(3, 22);
        this.strengthTab.addWidget(new GuiButtonSpecial(1, 16, 16, 20, 20, "--"));
        this.strengthTab.addWidget(new GuiButtonSpecial(2, 38, 16, 20, 20, "-"));
        this.strengthTab.addWidget(new GuiButtonSpecial(3, 60, 16, 20, 20, "+"));
        this.strengthTab.addWidget(new GuiButtonSpecial(4, 82, 16, 20, 20, "++"));
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("GPS", 50, 20, 0x404040);
        this.field_146289_q.func_78276_b("Upgr.", 13, 19, 0x404040);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.statusStat.setText(this.getStatusText());
        this.strengthTab.setTitle("Force: " + ((TileEntityAirCannon)this.te).forceMult + "%%");
        if (this.gpsX != ((TileEntityAirCannon)this.te).gpsX || this.gpsY != ((TileEntityAirCannon)this.te).gpsY || this.gpsZ != ((TileEntityAirCannon)this.te).gpsZ) {
            this.gpsX = ((TileEntityAirCannon)this.te).gpsX;
            this.gpsY = ((TileEntityAirCannon)this.te).gpsY;
            this.gpsZ = ((TileEntityAirCannon)this.te).gpsZ;
            this.statusStat.openWindow();
        }
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        text.add("\u00a77Current Aimed Coordinate:");
        if (((TileEntityAirCannon)this.te).gpsX != 0 || ((TileEntityAirCannon)this.te).gpsY != 0 || ((TileEntityAirCannon)this.te).gpsZ != 0) {
            text.add("\u00a70X: " + ((TileEntityAirCannon)this.te).gpsX + ", Y: " + ((TileEntityAirCannon)this.te).gpsY + ", Z: " + ((TileEntityAirCannon)this.te).gpsZ);
        } else {
            text.add("\u00a70- No coordinate selected -");
        }
        text.add("\u00a77Current Heading Angle:");
        text.add("\u00a70" + Math.round(((TileEntityAirCannon)this.te).rotationAngle) + " degrees.");
        text.add("\u00a77Current Height Angle:");
        text.add("\u00a70" + (90 - Math.round(((TileEntityAirCannon)this.te).heightAngle)) + " degrees.");
        text.add(TextFormatting.GRAY + "Range");
        text.add(TextFormatting.BLACK + "About " + PneumaticCraftUtils.roundNumberTo(((TileEntityAirCannon)this.te).getForce() * 25.0f, 0) + "m");
        return text;
    }

    @Override
    protected void addProblems(List<String> textList) {
        List<Pair<EnumFacing, IAirHandler>> teSurrounding = ((TileEntityAirCannon)this.te).getAirHandler(null).getConnectedPneumatics();
        super.addProblems(textList);
        if (teSurrounding.isEmpty()) {
            textList.add("\u00a77No air input connected.");
            textList.add("\u00a70Add pipes / machines");
            textList.add("\u00a70to the input.");
        }
        if (((TileEntityAirCannon)this.te).getPrimaryInventory().getStackInSlot(0).func_190926_b()) {
            textList.add("\u00a77No items to fire");
            textList.add("\u00a70Add items in the");
            textList.add("\u00a70cannon slot.");
        }
        if (!((TileEntityAirCannon)this.te).hasCoordinate()) {
            textList.add("\u00a77No destination coordinate set");
            textList.add("\u00a70Put a GPS Tool with a");
            textList.add("\u00a70coordinate set in the GPS slot.");
        } else if (!((TileEntityAirCannon)this.te).coordWithinReach) {
            textList.add("\u00a77Selected coordinate");
            textList.add("\u00a77can't be reached");
            textList.add("\u00a70Select a coordinate");
            textList.add("\u00a70closer to the cannon.");
        } else if (((TileEntityAirCannon)this.te).getRedstoneMode() == 0 && !((TileEntityAirCannon)this.te).doneTurning) {
            textList.add("\u00a77Cannon still turning");
            textList.add("\u00a70Wait for the cannon");
        } else if (((TileEntityAirCannon)this.te).getRedstoneMode() == 2 && !((TileEntityAirCannon)this.te).insertingInventoryHasSpace) {
            textList.add("\u00a77The last shot inventory does not have space for the items in the Cannon.");
        }
    }

    @Override
    protected void addInformation(List<String> curInfo) {
        super.addInformation(curInfo);
        if (curInfo.isEmpty()) {
            curInfo.add("\u00a70Apply a redstone signal to fire.");
        }
    }
}

