/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.awt.Point;
import java.util.List;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.common.inventory.ContainerThermalCompressor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityThermalCompressor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.StringUtils;

public class GuiThermalCompressor
extends GuiPneumaticContainerBase<TileEntityThermalCompressor> {
    public GuiThermalCompressor(InventoryPlayer inv, TileEntityThermalCompressor te) {
        super(new ContainerThermalCompressor(inv, te), te, "pneumaticcraft:textures/gui/gui_thermal_compressor.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addWidget(new WidgetTemperatureSided(EnumFacing.NORTH, 63));
        this.addWidget(new WidgetTemperatureSided(EnumFacing.SOUTH, 73));
        this.addWidget(new WidgetTemperatureSided(EnumFacing.WEST, 88));
        this.addWidget(new WidgetTemperatureSided(EnumFacing.EAST, 98));
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Upgr.", 28, 19, 0x404040);
    }

    @Override
    protected Point getGaugeLocation() {
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        return new Point(xStart + (int)((double)this.field_146999_f * 0.82), yStart + this.field_147000_g / 4 + 4);
    }

    private int getTemperatureDifferential(EnumFacing side) {
        return Math.abs(((TileEntityThermalCompressor)this.te).getHeatExchangerLogic(side).getTemperatureAsInt() - ((TileEntityThermalCompressor)this.te).getHeatExchangerLogic(side.func_176734_d()).getTemperatureAsInt());
    }

    @Override
    protected void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        int d = this.getTemperatureDifferential(EnumFacing.NORTH) + this.getTemperatureDifferential(EnumFacing.EAST);
        if (d == 0) {
            curInfo.add("\u00a7fNo temperature differential");
            curInfo.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a70Place a hot block on any side of the compressor, and a cold block on the opposite side."));
        }
    }

    @Override
    protected void addWarnings(List<String> curInfo) {
        super.addWarnings(curInfo);
        int d = this.getTemperatureDifferential(EnumFacing.NORTH) + this.getTemperatureDifferential(EnumFacing.EAST);
        if (d > 0 && d < 20) {
            curInfo.add("\u00a7fPoor temperature differential");
            curInfo.addAll(PneumaticCraftUtils.convertStringIntoList("\u00a70Place a hot block on any side of the compressor, and a cold block on the opposite side."));
        }
    }

    private class WidgetTemperatureSided
    extends WidgetTemperature {
        private final EnumFacing side;

        WidgetTemperatureSided(EnumFacing side, int x) {
            super(side.func_176736_b(), GuiThermalCompressor.this.field_147003_i + x, GuiThermalCompressor.this.field_147009_r + 20, 0, 2000, ((IHeatExchanger)((Object)GuiThermalCompressor.this.te)).getHeatExchangerLogic(side), new int[0]);
            this.side = side;
        }

        @Override
        public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shift) {
            curTip.add(StringUtils.capitalize((String)this.side.func_176610_l()) + " Temperature: " + (this.logic.getTemperatureAsInt() - 273) + "\u00b0C");
        }
    }
}

