/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import me.desht.pneumaticcraft.client.gui.widget.WidgetBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.Validate;
import org.lwjgl.input.Mouse;

public class WidgetVerticalScrollbar
extends WidgetBase {
    private static final ResourceLocation SCROLL_TEXTURE = new ResourceLocation("pneumaticcraft:textures/gui/widget/vertical_scrollbar.png");
    public float currentScroll;
    private int states;
    private boolean listening;
    private boolean dragging;
    private boolean wasClicking;
    private boolean enabled = true;

    public WidgetVerticalScrollbar(int x, int y, int height) {
        this(-1, x, y, height);
    }

    public WidgetVerticalScrollbar(int id, int x, int y, int height) {
        super(id, x, y, 14, height);
    }

    public WidgetVerticalScrollbar setStates(int states) {
        this.states = states;
        return this;
    }

    public WidgetVerticalScrollbar setCurrentState(int state) {
        Validate.isTrue((state >= 0 && state <= this.states ? 1 : 0) != 0, (String)("State " + state + " out of range! Valid range [1 - " + this.states + "] inclusive"), (Object[])new Object[0]);
        this.currentScroll = (float)state / (float)this.states;
        return this;
    }

    @Override
    public void handleMouseInput() {
        if (this.listening) {
            int wheel = -Mouse.getDWheel();
            wheel = MathHelper.func_76125_a((int)wheel, (int)-1, (int)1);
            this.currentScroll += (float)wheel / (float)this.states;
        }
    }

    public WidgetVerticalScrollbar setListening(boolean listening) {
        this.listening = listening;
        return this;
    }

    public int getState() {
        float scroll = this.currentScroll;
        return MathHelper.func_76125_a((int)((int)((scroll += 0.5f / (float)this.states) * (float)this.states)), (int)0, (int)this.states);
    }

    public WidgetVerticalScrollbar setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.wasClicking = false;
        }
        return this;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!Mouse.isButtonDown((int)0)) {
            this.dragging = false;
        }
        if (!this.wasClicking && Mouse.isButtonDown((int)0) && this.getBounds().contains(mouseX, mouseY)) {
            this.dragging = true;
        }
        if (!this.enabled) {
            this.dragging = false;
        }
        this.wasClicking = Mouse.isButtonDown((int)0);
        if (this.dragging) {
            this.currentScroll = (float)(mouseY - 7 - this.getBounds().y) / (float)(this.getBounds().height - 17);
        }
        this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(SCROLL_TEXTURE);
        Gui.func_146110_a((int)this.x, (int)this.y, (float)12.0f, (float)0.0f, (int)this.getBounds().width, (int)1, (float)26.0f, (float)15.0f);
        for (int i = 0; i < this.getBounds().height - 2; ++i) {
            Gui.func_146110_a((int)this.x, (int)(this.y + 1 + i), (float)12.0f, (float)1.0f, (int)this.getBounds().width, (int)1, (float)26.0f, (float)15.0f);
        }
        Gui.func_146110_a((int)this.x, (int)(this.y + this.getBounds().height - 1), (float)12.0f, (float)14.0f, (int)this.getBounds().width, (int)1, (float)26.0f, (float)15.0f);
        if (!this.enabled) {
            GlStateManager.func_179131_c((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
        }
        Gui.func_146110_a((int)(this.x + 1), (int)(this.y + 1 + (int)((float)(this.getBounds().height - 17) * this.currentScroll)), (float)0.0f, (float)0.0f, (int)12, (int)15, (float)26.0f, (float)15.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean isDragging() {
        return this.dragging;
    }
}

