/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.IClientRegistry;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.api.drone.IDroneRegistry;
import me.desht.pneumaticcraft.api.harvesting.IHarvestRegistry;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.recipe.IPneumaticRecipeRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerSupplier;
import me.desht.pneumaticcraft.api.tileentity.IHeatRegistry;
import me.desht.pneumaticcraft.api.universalSensor.ISensorRegistry;
import me.desht.pneumaticcraft.client.GuiRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.common.DroneRegistry;
import me.desht.pneumaticcraft.common.fluid.Fluids;
import me.desht.pneumaticcraft.common.harvesting.HarvestRegistry;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.pressure.AirHandlerSupplier;
import me.desht.pneumaticcraft.common.recipes.PneumaticRecipeRegistry;
import me.desht.pneumaticcraft.common.sensor.SensorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.Validate;

public class PneumaticCraftAPIHandler
implements PneumaticRegistry.IPneumaticCraftInterface {
    private static final PneumaticCraftAPIHandler INSTANCE = new PneumaticCraftAPIHandler();
    public final Map<Fluid, Integer> liquidXPs = new HashMap<Fluid, Integer>();
    public final List<Fluid> availableLiquidXPs = new ArrayList<Fluid>();
    public final Map<String, Integer> liquidFuels = new HashMap<String, Integer>();

    public static PneumaticCraftAPIHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public IPneumaticRecipeRegistry getRecipeRegistry() {
        return PneumaticRecipeRegistry.getInstance();
    }

    @Override
    public IAirHandlerSupplier getAirHandlerSupplier() {
        return AirHandlerSupplier.getInstance();
    }

    @Override
    public IPneumaticHelmetRegistry getHelmetRegistry() {
        return PneumaticHelmetRegistry.getInstance();
    }

    @Override
    public IDroneRegistry getDroneRegistry() {
        return DroneRegistry.getInstance();
    }

    @Override
    public IHeatRegistry getHeatRegistry() {
        return HeatExchangerManager.getInstance();
    }

    @Override
    public int getProtectingSecurityStations(World world, BlockPos pos, EntityPlayer player, boolean showRangeLines) {
        Validate.isTrue((!world.field_72995_K ? 1 : 0) != 0, (String)"This method can only be called from the server side!", (Object[])new Object[0]);
        return PneumaticCraftUtils.getProtectingSecurityStations(world, pos, player, showRangeLines, false);
    }

    @Override
    public void registerXPLiquid(Fluid fluid, int liquidToPointRatio) {
        Validate.notNull((Object)fluid, (String)"Fluid may not be null!", (Object[])new Object[0]);
        if (liquidToPointRatio <= 0) {
            this.liquidXPs.remove(fluid);
            this.availableLiquidXPs.remove(fluid);
        } else {
            this.liquidXPs.put(fluid, liquidToPointRatio);
            this.availableLiquidXPs.add(fluid);
        }
    }

    @Override
    @Deprecated
    public void registerRefineryInput(Fluid fluid) {
        PneumaticRecipeRegistry registry = PneumaticRecipeRegistry.getInstance();
        registry.registerRefineryRecipe(new FluidStack(fluid, 10), new FluidStack(Fluids.DIESEL, 4), new FluidStack(Fluids.LPG, 2));
        registry.registerRefineryRecipe(new FluidStack(fluid, 10), new FluidStack(Fluids.DIESEL, 2), new FluidStack(Fluids.KEROSENE, 3), new FluidStack(Fluids.LPG, 2));
        registry.registerRefineryRecipe(new FluidStack(fluid, 10), new FluidStack(Fluids.DIESEL, 2), new FluidStack(Fluids.KEROSENE, 3), new FluidStack(Fluids.GASOLINE, 3), new FluidStack(Fluids.LPG, 2));
    }

    @Override
    public void registerPlasticFluid(Fluid fluid, int ratio) {
        PneumaticRecipeRegistry.getInstance().registerPlasticMixerRecipe(new FluidStack(fluid, ratio), new ItemStack(Itemss.PLASTIC), 423, true, true, true, -1);
    }

    @Override
    public void registerFuel(Fluid fluid, int mLPerBucket) {
        Validate.notNull((Object)fluid);
        Validate.isTrue((mLPerBucket >= 0 ? 1 : 0) != 0, (String)"mlPerBucket can't be < 0!", (Object[])new Object[0]);
        if (this.liquidFuels.containsKey(fluid.getName())) {
            Log.info("Overriding liquid fuel entry " + fluid.getLocalizedName(new FluidStack(fluid, 1)) + " (" + fluid.getName() + ") with a fuel value of " + mLPerBucket + " (previously " + this.liquidFuels.get(fluid.getName()) + ")");
            if (mLPerBucket == 0) {
                this.liquidFuels.remove(fluid.getName());
            }
        }
        if (mLPerBucket > 0) {
            this.liquidFuels.put(fluid.getName(), mLPerBucket);
        }
    }

    @Override
    public IClientRegistry getGuiRegistry() {
        return GuiRegistry.getInstance();
    }

    @Override
    public ISensorRegistry getSensorRegistry() {
        return SensorHandler.getInstance();
    }

    @Override
    public IItemRegistry getItemRegistry() {
        return ItemRegistry.getInstance();
    }

    @Override
    public IHarvestRegistry getHarvestRegistry() {
        return HarvestRegistry.getInstance();
    }
}

