/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.harvesting.IHarvestHandler;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.harvesting.HarvestRegistry;
import me.desht.pneumaticcraft.common.progwidgets.IToolUser;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;

public class DroneAIHarvest
extends DroneAIBlockInteraction<ProgWidgetAreaItemBase> {
    public DroneAIHarvest(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
    }

    @Override
    public boolean func_75250_a() {
        if (this.abortIfRequiredHoeIsMissing()) {
            return false;
        }
        return super.func_75250_a();
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        if (this.abortIfRequiredHoeIsMissing()) {
            return false;
        }
        return this.getApplicableHandler(pos) != null;
    }

    private boolean abortIfRequiredHoeIsMissing() {
        if (((IToolUser)((Object)this.widget)).requiresTool() && this.getDamageableHoe() == null) {
            this.abort();
            this.drone.addDebugEntry("gui.progWidget.harvest.debug.missingHoe");
            return true;
        }
        return false;
    }

    private IHarvestHandler getApplicableHandler(BlockPos pos) {
        IBlockState state = this.worldCache.func_180495_p(pos);
        return HarvestRegistry.getInstance().getHarvestHandlers().stream().filter(handler -> handler.canHarvest(this.drone.world(), this.worldCache, pos, state, this.drone) && this.hasApplicableItemFilters((IHarvestHandler)handler, pos, state)).findFirst().orElse(null);
    }

    private boolean hasApplicableItemFilters(IHarvestHandler harvestHandler, BlockPos pos, IBlockState blockState) {
        NonNullList droppedStacks = NonNullList.func_191196_a();
        harvestHandler.addFilterItems(this.drone.world(), this.worldCache, pos, blockState, (NonNullList<ItemStack>)droppedStacks, this.drone);
        for (ItemStack droppedStack : droppedStacks) {
            if (!this.widget.isItemValidForFilters(droppedStack, blockState)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean respectClaims() {
        return true;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        IHarvestHandler applicableHandler = this.getApplicableHandler(pos);
        if (applicableHandler != null) {
            IBlockState state = this.worldCache.func_180495_p(pos);
            if (applicableHandler.canHarvest(this.drone.world(), this.worldCache, pos, state, this.drone)) {
                Consumer<EntityPlayer> damageableHoe = this.getDamageableHoe();
                if (damageableHoe != null) {
                    if (applicableHandler.harvestAndReplant(this.drone.world(), this.worldCache, pos, state, this.drone)) {
                        damageableHoe.accept((EntityPlayer)this.drone.getFakePlayer());
                    }
                } else {
                    applicableHandler.harvest(this.drone.world(), this.worldCache, pos, state, this.drone);
                }
            }
        }
        return false;
    }

    private Consumer<EntityPlayer> getDamageableHoe() {
        for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
            ItemStack stack = this.drone.getInv().getStackInSlot(i);
            BiConsumer<ItemStack, EntityPlayer> damageableHoe = HarvestRegistry.getInstance().getDamageableHoe(stack);
            if (damageableHoe == null) continue;
            return player -> damageableHoe.accept(stack, (EntityPlayer)player);
        }
        return null;
    }
}

