/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.Comparator;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.ai.DroneClaimManager;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.util.GlobalTileEntityCacheManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class DroneGoToChargingStation
extends EntityAIBase {
    private final EntityDrone drone;
    private TileEntityChargingStation curCharger;
    private int chargingTime;
    public boolean isExecuting;

    public DroneGoToChargingStation(EntityDrone drone) {
        this.drone = drone;
        this.func_75248_a(63);
    }

    public boolean func_75250_a() {
        ArrayList<TileEntityChargingStation> validChargingStations = new ArrayList<TileEntityChargingStation>();
        if (this.drone.getPressure(null) < 1.0f) {
            for (TileEntityChargingStation station : GlobalTileEntityCacheManager.getInstance().chargingStations) {
                if (station.func_145831_w() != this.drone.field_70170_p) continue;
                BlockPos pos = new BlockPos(station.func_174877_v().func_177958_n(), station.func_174877_v().func_177956_o(), station.func_174877_v().func_177952_p());
                if (DroneClaimManager.getInstance(this.drone.field_70170_p).isClaimed(pos)) {
                    this.drone.addDebugEntry("gui.progWidget.chargingStation.debug.claimed", pos);
                    continue;
                }
                if (station.getPressure() <= 1.0f) {
                    this.drone.addDebugEntry("gui.progWidget.chargingStation.debug.notEnoughPressure", pos);
                    continue;
                }
                if (station.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) == 0) {
                    this.drone.addDebugEntry("gui.progWidget.chargingStation.debug.noDispenserUpgrades", pos);
                    continue;
                }
                validChargingStations.add(station);
            }
        }
        validChargingStations.sort(Comparator.comparingDouble(arg -> PneumaticCraftUtils.distBetweenSq(arg.func_174877_v().func_177958_n(), arg.func_174877_v().func_177956_o(), arg.func_174877_v().func_177952_p(), this.drone.field_70165_t, this.drone.field_70163_u, this.drone.field_70161_v)));
        for (TileEntityChargingStation station : validChargingStations) {
            boolean protect = PneumaticCraftUtils.getProtectingSecurityStations(this.drone.field_70170_p, station.func_174877_v(), (EntityPlayer)this.drone.getFakePlayer(), false, false) > 0;
            BlockPos pos = new BlockPos((Vec3i)station.func_174877_v());
            if (protect) {
                this.drone.addDebugEntry("gui.progWidget.chargingStation.debug.protected", pos);
                continue;
            }
            if (this.drone.getPathNavigator().moveToXYZ(station.func_174877_v().func_177958_n(), station.func_174877_v().func_177956_o() + 1, station.func_174877_v().func_177952_p()) || this.drone.getPathNavigator().isGoingToTeleport()) {
                this.isExecuting = true;
                this.curCharger = station;
                DroneClaimManager.getInstance(this.drone.field_70170_p).claim(pos);
                return true;
            }
            this.drone.addDebugEntry("gui.progWidget.chargingStation.debug.cantNavigate", pos);
        }
        this.isExecuting = false;
        return false;
    }

    public boolean func_75253_b() {
        if (this.curCharger.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) == 0 || this.curCharger.func_145837_r()) {
            this.isExecuting = false;
            return false;
        }
        if (!this.drone.getPathNavigator().isGoingToTeleport() && (this.drone.func_70661_as().func_75505_d() == null || this.drone.func_70661_as().func_75505_d().func_75879_b())) {
            boolean bl = this.isExecuting = this.drone.getPressure(null) < 9.9f && this.curCharger.getPressure() > this.drone.getPressure(null) + 0.1f;
            if (this.isExecuting) {
                ++this.chargingTime;
                if (this.chargingTime > 20) {
                    this.drone.getPathNavigator().moveToXYZ(this.curCharger.func_174877_v().func_177958_n(), (double)this.curCharger.func_174877_v().func_177956_o() + 1.5, this.curCharger.func_174877_v().func_177952_p());
                    if (this.drone.func_70661_as().func_75505_d() == null || this.drone.func_70661_as().func_75505_d().func_75879_b()) {
                        this.drone.setStandby(true);
                    } else {
                        this.chargingTime = 0;
                    }
                }
                DroneClaimManager.getInstance(this.drone.field_70170_p).claim(new BlockPos(this.curCharger.func_174877_v().func_177958_n(), this.curCharger.func_174877_v().func_177956_o(), this.curCharger.func_174877_v().func_177952_p()));
            }
            return this.isExecuting;
        }
        this.chargingTime = 0;
        DroneClaimManager.getInstance(this.drone.field_70170_p).claim(new BlockPos(this.curCharger.func_174877_v().func_177958_n(), this.curCharger.func_174877_v().func_177956_o(), this.curCharger.func_174877_v().func_177952_p()));
        return this.drone.isAccelerating();
    }
}

