/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.EntityTrackEvent;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.InventoryTrackEvent;
import me.desht.pneumaticcraft.api.drone.AmadronRetrievalEvent;
import me.desht.pneumaticcraft.api.drone.DroneConstructingEvent;
import me.desht.pneumaticcraft.api.drone.DroneSuicideEvent;
import me.desht.pneumaticcraft.common.DroneRegistry;
import me.desht.pneumaticcraft.common.PneumaticCraftAPIHandler;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.ai.EntityAINoAIWhenRidingDrone;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.block.tubes.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.capabilities.hacking.CapabilityHackingProvider;
import me.desht.pneumaticcraft.common.config.AmadronOfferStaticConfig;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.entity.EntityProgrammableController;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.hacking.entity.HackableEnderman;
import me.desht.pneumaticcraft.common.item.ItemAmadronTablet;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketRotateBlock;
import me.desht.pneumaticcraft.common.recipes.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.AmadronOfferCustom;
import me.desht.pneumaticcraft.common.recipes.AmadronOfferManager;
import me.desht.pneumaticcraft.common.recipes.ExplosionCraftingRecipe;
import me.desht.pneumaticcraft.common.remote.GlobalVariableManager;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.tileentity.TileEntityRefinery;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandlerPneumaticCraft {
    @SubscribeEvent
    public void handleFuelEvent(FurnaceFuelBurnTimeEvent event) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)event.getItemStack());
        if (fluidStack != null && "pneumaticcraft".equals(FluidRegistry.getModId((FluidStack)fluidStack))) {
            int value = PneumaticCraftAPIHandler.getInstance().liquidFuels.getOrDefault(fluidStack.getFluid().getName(), -1);
            event.setBurnTime(value > 0 ? (int)((float)value * ConfigHandler.general.fuelBucketEfficiencyMultiplier) : -1);
        }
    }

    @SubscribeEvent
    public void explosionCraftingEvent(ExplosionEvent.Detonate event) {
        if (!ConfigHandler.general.explosionCrafting) {
            return;
        }
        Iterator iterator = event.getAffectedEntities().iterator();
        while (iterator.hasNext()) {
            ItemStack result;
            ItemStack stack;
            Entity entity = (Entity)iterator.next();
            if (!(entity instanceof EntityItem) || entity.field_70128_L || (stack = ((EntityItem)entity).func_92059_d()).func_190926_b() || (result = ExplosionCraftingRecipe.tryToCraft(stack)).func_190926_b()) continue;
            ((EntityItem)entity).func_92058_a(result);
            iterator.remove();
            this.checkForAdvancement(event, result);
        }
    }

    private void checkForAdvancement(ExplosionEvent.Detonate event, ItemStack result) {
        if (!(event.getWorld().field_72995_K || result.func_77973_b() != Itemss.INGOT_IRON_COMPRESSED && result.func_77973_b() != Item.func_150898_a((Block)Blockss.COMPRESSED_IRON))) {
            Vec3d exp = event.getExplosion().getPosition();
            for (EntityPlayer player : event.getWorld().func_72872_a(EntityPlayer.class, new AxisAlignedBB(exp.field_72450_a - 32.0, exp.field_72448_b - 32.0, exp.field_72449_c - 32.0, exp.field_72450_a + 32.0, exp.field_72448_b + 32.0, exp.field_72449_c + 32.0))) {
                AdvancementTriggers.EXPLODE_IRON.trigger((EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof IDroneBase) {
            MinecraftForge.EVENT_BUS.post((Event)new DroneConstructingEvent((IDroneBase)event.getEntity()));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K) {
            if (event.getEntity() instanceof EntityLiving) {
                ((EntityLiving)event.getEntity()).field_70714_bg.func_75776_a(Integer.MIN_VALUE, (EntityAIBase)new EntityAINoAIWhenRidingDrone((EntityLiving)event.getEntity()));
            }
        } else if (event.getEntity() instanceof EntityPlayer && event.getEntity().func_145782_y() == PneumaticCraftRepressurized.proxy.getClientPlayer().func_145782_y()) {
            SemiBlockManager.getInstance(event.getWorld()).clearAll();
        }
    }

    @SubscribeEvent
    public void onEntityConstruction(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(PneumaticCraftUtils.RL("hacking"), (ICapabilityProvider)new CapabilityHackingProvider());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEnderTeleport(EnderTeleportEvent event) {
        Entity e = event.getEntity();
        if (!HackableEnderman.onEndermanTeleport(e)) {
            event.setCanceled(true);
        }
        if (e.func_130014_f_().func_180495_p(e.func_180425_c()).func_177230_c() == Blockss.FAKE_ICE) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        Fluid fluid;
        Block b;
        RayTraceResult rtr = event.getTarget();
        if (rtr != null && (b = event.getWorld().func_180495_p(rtr.func_178782_a()).func_177230_c()) instanceof IFluidBlock && TileEntityRefinery.isInputFluidValid(fluid = ((IFluidBlock)b).getFluid(), 4) && event.getEntityPlayer() instanceof EntityPlayerMP) {
            AdvancementTriggers.OIL_BUCKET.trigger((EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerClick(PlayerInteractEvent event) {
        if (event instanceof PlayerInteractEvent.RightClickEmpty) {
            return;
        }
        ItemStack heldItem = event.getEntityPlayer().func_184586_b(event.getHand());
        IBlockState interactedBlockState = event.getWorld().func_180495_p(event.getPos());
        Block interactedBlock = interactedBlockState.func_177230_c();
        if (!(event.getEntityPlayer().field_71075_bZ.field_75098_d && event.getEntityPlayer().func_70003_b(2, "securityStation") || event.getWorld() == null || event.getWorld().field_72995_K || interactedBlock == Blockss.SECURITY_STATION && !(event instanceof PlayerInteractEvent.LeftClickBlock))) {
            boolean tryingToPlaceSecurityStation = heldItem.func_77973_b() instanceof ItemBlock && ((ItemBlock)heldItem.func_77973_b()).func_179223_d() == Blockss.SECURITY_STATION;
            int blockingStations = PneumaticCraftUtils.getProtectingSecurityStations(event.getWorld(), event.getPos(), event.getEntityPlayer(), true, tryingToPlaceSecurityStation);
            if (blockingStations > 0) {
                event.setCanceled(true);
                event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentTranslation(tryingToPlaceSecurityStation ? "message.securityStation.stationPlacementPrevented" : "message.securityStation.accessPrevented", new Object[]{blockingStations}), false);
            }
        }
    }

    @SubscribeEvent
    public void onModdedWrenchBlock(PlayerInteractEvent.RightClickBlock event) {
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        if (!event.isCanceled() && state.func_177230_c() instanceof IPneumaticWrenchable) {
            if (event.getHand() == EnumHand.OFF_HAND && ModdedWrenchUtils.getInstance().isModdedWrench(event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND))) {
                event.setCanceled(true);
            } else if (ModdedWrenchUtils.getInstance().isModdedWrench(event.getEntityPlayer().func_184586_b(event.getHand()))) {
                if (event.getWorld().field_72995_K) {
                    NetworkHandler.sendToServer(new PacketRotateBlock(event.getPos(), event.getFace(), event.getHand()));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onModdedWrenchEntity(PlayerInteractEvent.EntityInteract event) {
        if (!event.isCanceled() && event.getTarget() instanceof IPneumaticWrenchable) {
            if (event.getHand() == EnumHand.OFF_HAND && ModdedWrenchUtils.getInstance().isModdedWrench(event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND))) {
                event.setCanceled(true);
            } else if (ModdedWrenchUtils.getInstance().isModdedWrench(event.getEntityPlayer().func_184586_b(event.getHand()))) {
                if (event.getWorld().field_72995_K) {
                    NetworkHandler.sendToServer(new PacketRotateBlock(event.getPos(), event.getHand(), event.getTarget().func_145782_y()));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void quetziMoo(ServerChatEvent event) {
        if (event.getUsername().equals("Quetzz") && event.getMessage().equals("m00")) {
            for (int i = 0; i < 4; ++i) {
                NetworkHandler.sendTo(new PacketPlaySound(SoundEvents.field_187558_ak, SoundCategory.NEUTRAL, event.getPlayer().field_70165_t, event.getPlayer().field_70163_u, event.getPlayer().field_70161_v, 1.0f, 1.0f, true), event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            if (event.getWorld().field_73011_w.getDimension() == 0) {
                GlobalVariableManager.overworld = event.getWorld();
                event.getWorld().func_72943_a(GlobalVariableManager.class, "PneumaticCraftGlobalVariables");
            }
            ModuleNetworkManager.getInstance(event.getWorld()).invalidateCache();
        }
    }

    @SubscribeEvent
    public void onEntityTracking(EntityTrackEvent event) {
        if (event.trackingEntity instanceof EntityProgrammableController) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInventoryTracking(InventoryTrackEvent event) {
        if (event.getTileEntity() instanceof TileEntityProgrammer) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDroneSuicide(DroneSuicideEvent event) {
        EntityDrone drone;
        AmadronOffer offer;
        if (event.drone instanceof EntityDrone && (offer = (drone = (EntityDrone)event.drone).getHandlingOffer()) != null) {
            int times = drone.getOfferTimes();
            if (offer.getInput() instanceof ItemStack) {
                int i;
                int requiredCount = ((ItemStack)offer.getInput()).func_190916_E() * times;
                for (i = 0; i < drone.getInv().getSlots(); ++i) {
                    requiredCount -= drone.getInv().getStackInSlot(i).func_190916_E();
                }
                if (requiredCount <= 0) {
                    for (i = 0; i < drone.getInv().getSlots(); ++i) {
                        drone.getInv().setStackInSlot(i, ItemStack.field_190927_a);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new AmadronRetrievalEvent(event.drone));
                }
            } else {
                int requiredCount = ((FluidStack)offer.getInput()).amount * times;
                if (drone.getTank().getFluidAmount() >= requiredCount) {
                    MinecraftForge.EVENT_BUS.post((Event)new AmadronRetrievalEvent(event.drone));
                }
            }
        }
    }

    @SubscribeEvent
    public void onAmadronSuccess(AmadronRetrievalEvent event) {
        EntityDrone drone = (EntityDrone)event.drone;
        AmadronOffer offer = drone.getHandlingOffer();
        boolean shouldDeliver = false;
        if (offer instanceof AmadronOfferCustom) {
            boolean shouldSave = false;
            AmadronOffer realOffer = AmadronOfferManager.getInstance().get(offer);
            if (realOffer != null) {
                ((AmadronOfferCustom)realOffer).addPayment(drone.getOfferTimes());
                ((AmadronOfferCustom)realOffer).addStock(-drone.getOfferTimes());
                realOffer.onTrade(drone.getOfferTimes(), drone.getBuyingPlayer());
                shouldDeliver = true;
                shouldSave = true;
            }
            if ((realOffer = AmadronOfferManager.getInstance().get(((AmadronOfferCustom)offer).copy().invert())) != null) {
                ((AmadronOfferCustom)realOffer).addStock(drone.getOfferTimes());
                shouldSave = true;
            }
            if (shouldSave) {
                try {
                    AmadronOfferStaticConfig.INSTANCE.writeToFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            shouldDeliver = true;
        }
        if (shouldDeliver) {
            ItemStack usedTablet = drone.getUsedTablet();
            if (offer.getOutput() instanceof ItemStack) {
                ItemStack stack;
                ItemStack offeringItems = (ItemStack)offer.getOutput();
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int producedItems = offeringItems.func_190916_E() * drone.getOfferTimes(); producedItems > 0; producedItems -= stack.func_190916_E()) {
                    stack = offeringItems.func_77946_l();
                    stack.func_190920_e(Math.min(producedItems, stack.func_77976_d()));
                    stacks.add(stack);
                }
                BlockPos pos = ItemAmadronTablet.getItemProvidingLocation(usedTablet);
                if (pos != null) {
                    WorldServer world = DimensionManager.getWorld((int)ItemAmadronTablet.getItemProvidingDimension(usedTablet));
                    DroneRegistry.getInstance().deliverItemsAmazonStyle((World)world, pos, stacks.toArray(new ItemStack[0]));
                }
            } else {
                FluidStack offeringFluid = ((FluidStack)offer.getOutput()).copy();
                offeringFluid.amount *= drone.getOfferTimes();
                BlockPos pos = ItemAmadronTablet.getLiquidProvidingLocation(usedTablet);
                if (pos != null) {
                    WorldServer world = DimensionManager.getWorld((int)ItemAmadronTablet.getLiquidProvidingDimension(usedTablet));
                    DroneRegistry.getInstance().deliverFluidAmazonStyle((World)world, pos, offeringFluid);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (ConfigHandler.general.enableDungeonLoot) {
            String prefix = "minecraft:chests/";
            String name = event.getName().toString();
            if (name.startsWith(prefix)) {
                String file;
                switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                    case "abandoned_mineshaft": 
                    case "desert_pyramid": 
                    case "jungle_temple": 
                    case "simple_dungeon": 
                    case "spawn_bonus_chest": 
                    case "stronghold_corridor": 
                    case "village_blacksmith": {
                        LootEntryTable entry = new LootEntryTable(PneumaticCraftUtils.RL("inject/simple_dungeon_loot"), 1, 0, new LootCondition[0], "pneumaticcraft_inject_entry");
                        LootPool pool = new LootPool(new LootEntry[]{entry}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "pneumaticcraft_inject_pool");
                        event.getTable().addPool(pool);
                        break;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            if (event.getSlot() == EntityEquipmentSlot.MAINHAND) {
                if (event.getTo().func_77973_b() == Itemss.MINIGUN) {
                    NBTUtil.initNBTTagCompound(event.getTo());
                    event.getTo().func_77978_p().func_74768_a("owningPlayerId", event.getEntityLiving().func_145782_y());
                } else if (event.getFrom().func_77973_b() == Itemss.MINIGUN) {
                    NBTUtil.initNBTTagCompound(event.getFrom());
                    event.getFrom().func_77978_p().func_82580_o("owningPlayerId");
                }
            } else if (event.getSlot().func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
                EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
                for (ItemStack stack : player.func_184193_aE()) {
                    if (stack.func_77973_b() instanceof ItemPneumaticArmor) continue;
                    return;
                }
                AdvancementTriggers.PNEUMATIC_ARMOR.trigger(player);
            }
        }
    }

    @SubscribeEvent
    public void entityMounting(EntityMountEvent event) {
        if (event.isMounting() && event.getEntityMounting() instanceof EntityDrone && (event.getEntityBeingMounted() instanceof EntityMinecart || event.getEntityBeingMounted() instanceof EntityBoat) && !event.getEntityBeingMounted().field_70122_E) {
            event.setCanceled(true);
        }
    }
}

